/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.mojang.datafixers.util.Pair;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.gear.etching.EtchingGearAttributes;
import iskallia.vault.gear.etching.EtchingHelper;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.mana.Mana;
import iskallia.vault.network.message.NovaParticleMessage;
import iskallia.vault.skill.ability.effect.spi.AbstractNovaAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.SkillContext;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class NovaAbility
extends AbstractNovaAbility {
    public NovaAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float radius, float percentAbilityPowerDealt, float knockbackStrengthMultiplier) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost, radius, percentAbilityPowerDealt, knockbackStrengthMultiplier);
    }

    public NovaAbility() {
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            Vec3 pos = context.getSource().getPos().orElse(player.m_20182_());
            List<LivingEntity> targetEntities = this.getTargetEntities(player.f_19853_, (LivingEntity)player, pos);
            AtomicReference<Float> attackDamage = new AtomicReference<Float>(Float.valueOf(this.getAbilityPower((ServerPlayer)player)));
            EtchingHelper.getEtchings((LivingEntity)player, EtchingGearAttributes.NOVA_LOW_MANA_DAMAGE).forEach(stack -> {
                float current = Mana.get((Player)player);
                float max = Mana.getMax((Player)player);
                float threshold = ((Float)((Pair)stack.getValue()).getSecond()).floatValue();
                if (max > 0.0f && current / max < threshold) {
                    float mult = ((Float)((Pair)stack.getValue()).getFirst()).floatValue();
                    attackDamage.updateAndGet(damage -> Float.valueOf(damage.floatValue() + damage.floatValue() * mult));
                }
            });
            DamageSource damageSource = DamageSource.m_19344_((Player)player);
            for (LivingEntity entity : targetEntities) {
                if (entity.m_6673_(damageSource)) continue;
                float damageModifier = this.getDamageModifier(this.getRadius((Entity)player), player.m_20270_((Entity)entity));
                float finalAttackDamage = attackDamage.get().floatValue();
                ActiveFlags.IS_AP_ATTACKING.runIfNotSet(() -> ActiveFlags.IS_AOE_ATTACKING.runIfNotSet(() -> {
                    if (entity.m_6469_(damageSource, finalAttackDamage * damageModifier) && !Mth.m_14033_((float)this.getKnockbackStrengthMultiplier(), (float)0.0f)) {
                        double dz;
                        double dx = pos.f_82479_ - entity.m_20185_();
                        if (dx * dx + (dz = pos.f_82481_ - entity.m_20189_()) * dz < 1.0E-4) {
                            dx = (Math.random() - Math.random()) * 0.01;
                            dz = (Math.random() - Math.random()) * 0.01;
                        }
                        entity.m_147240_((double)(0.4f * this.getKnockbackStrengthMultiplier()), dx, dz);
                    }
                }));
            }
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    protected float getDamageModifier(float radius, float dist) {
        if (dist >= 0.0f && dist < radius / 5.0f * 1.0f) {
            return 1.0f;
        }
        if (dist >= radius / 5.0f * 1.0f && dist < radius / 5.0f * 2.0f) {
            return 0.8f;
        }
        if (dist >= radius / 5.0f * 2.0f && dist < radius / 5.0f * 3.0f) {
            return 0.6f;
        }
        if (dist >= radius / 5.0f * 3.0f && dist < radius / 5.0f * 4.0f) {
            return 0.4f;
        }
        if (dist >= radius / 5.0f * 4.0f) {
            return 0.2f;
        }
        return 0.2f;
    }

    @Override
    protected void doParticles(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            Vec3 pos = context.getSource().getPos().orElse(player.m_20182_());
            float radius = this.getRadius((Entity)player);
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new NovaParticleMessage(new Vec3(pos.f_82479_, pos.f_82480_ + (double)0.15f, pos.f_82481_), radius));
        });
    }

    @Override
    protected void doSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            Vec3 pos = context.getSource().getPos().orElse(player.m_20182_());
            player.f_19853_.m_6263_((Player)player, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11913_, SoundSource.PLAYERS, 0.2f, 1.0f);
            player.m_6330_(SoundEvents.f_11913_, SoundSource.PLAYERS, 0.2f, 1.0f);
        });
    }
}

