/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.EntityStunnedEvent;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.effect.InfiniteDurationEffect;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.gear.attribute.ability.special.FrostNovaVulnerabilityModification;
import iskallia.vault.gear.attribute.ability.special.base.ConfiguredModification;
import iskallia.vault.gear.attribute.ability.special.base.SpecialAbilityModification;
import iskallia.vault.gear.attribute.ability.special.base.template.value.IntValue;
import iskallia.vault.gear.etching.EtchingGearAttributes;
import iskallia.vault.gear.etching.EtchingHelper;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModParticles;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.effect.spi.AbstractNovaAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.AABBHelper;
import iskallia.vault.util.calc.EffectDurationHelper;
import iskallia.vault.util.effect.ScheduledEffectHelper;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class NovaSpeedAbility
extends AbstractNovaAbility {
    private int durationTicks;
    private int amplifier;
    private int damageIntervalTicks;
    private static final String TAG_ABILITY_DATA = "the_vault:ability/Nova_Slow";
    private static final String TAG_INTERVAL_TICKS = "intervalTicks";
    private static final String TAG_REMAINING_INTERVAL_TICKS = "remainingIntervalTicks";
    private static final String TAG_PLAYER_UUID = "playerUUID";

    public NovaSpeedAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float radius, float percentAttackDamageDealt, float knockbackStrengthMultiplier, int durationTicks, int amplifier, int damageIntervalTicks) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost, radius, percentAttackDamageDealt, knockbackStrengthMultiplier);
        this.durationTicks = durationTicks;
        this.amplifier = amplifier;
        this.damageIntervalTicks = damageIntervalTicks;
    }

    public NovaSpeedAbility() {
    }

    public int getDurationTicksUnmodified() {
        return this.durationTicks;
    }

    public int getDurationTicks(LivingEntity entity) {
        int duration = this.getDurationTicksUnmodified();
        return EffectDurationHelper.adjustEffectDurationFloor(entity, duration);
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public int getDamageIntervalTicks() {
        return this.damageIntervalTicks;
    }

    @Override
    public Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            float radius = this.getRadius((Entity)player);
            Vec3 pos = context.getSource().getPos().orElse(player.m_20182_());
            boolean allowPlayers = VaultUtils.getVault(player.f_19853_).map(VaultUtils::isPvPVault).orElse(false);
            List nearbyEntities = player.f_19853_.m_45971_(LivingEntity.class, TargetingConditions.m_148352_().m_26888_(entity -> allowPlayers || !(entity instanceof Player)).m_26883_((double)radius), (LivingEntity)player, AABBHelper.create(pos, radius));
            int vulnerabilityLevel = 0;
            for (ConfiguredModification mod : SpecialAbilityModification.getModifications((LivingEntity)player, FrostNovaVulnerabilityModification.class)) {
                vulnerabilityLevel += ((IntValue)mod.value()).getValue();
            }
            for (LivingEntity nearbyEntity : nearbyEntities) {
                nearbyEntity.m_7292_(new MobEffectInstance(ModEffects.CHILLED, this.getDurationTicks((LivingEntity)player), this.getAmplifier(), false, false, false));
                EtchingHelper.getEtchings((LivingEntity)player, EtchingGearAttributes.FROST_NOVA_FREEZE).stream().findFirst().ifPresent(stack -> {
                    float chance = ((Float)stack.getValue()).floatValue();
                    float random = player.f_19853_.f_46441_.nextFloat() * 100.0f;
                    if (random <= chance) {
                        nearbyEntity.m_21195_(ModEffects.GLACIAL_SHATTER);
                        nearbyEntity.m_7292_(new MobEffectInstance(ModEffects.GLACIAL_SHATTER, 40, 0));
                        player.f_19853_.m_6263_(null, nearbyEntity.m_20185_(), nearbyEntity.m_20186_(), nearbyEntity.m_20189_(), SoundEvents.f_11983_, SoundSource.BLOCKS, 0.25f, 0.65f);
                    }
                });
                CommonEvents.ENTITY_STUNNED.invoke(new EntityStunnedEvent.Data((LivingEntity)player, nearbyEntity));
                if (!nearbyEntity.m_21023_((MobEffect)ModEffects.HYPOTHERMIA)) {
                    ScheduledEffectHelper.invalidateAll(nearbyEntity, (MobEffect)ModEffects.HYPOTHERMIA);
                    ScheduledEffectHelper.scheduleEffect(nearbyEntity, ModEffects.HYPOTHERMIA.timedInstance(0, 400, true), this.getDurationTicks((LivingEntity)player));
                    NovaSpeedAbility.setAbilityData(nearbyEntity, this.getDamageIntervalTicks(), player.m_142081_());
                }
                if (vulnerabilityLevel <= 0) continue;
                int amplifier = vulnerabilityLevel - 1;
                nearbyEntity.m_7292_(new MobEffectInstance(ModEffects.VULNERABLE, this.getDurationTicks((LivingEntity)player) * 4, amplifier, false, false));
            }
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    protected void doParticles(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            float radius = this.getRadius((Entity)player);
            Vec3 pos = context.getSource().getPos().orElse(player.m_20182_());
            int particleCount = (int)Mth.m_14008_((double)(Math.pow(radius, 2.0) * 3.1415927410125732 * 100.0), (double)50.0, (double)400.0);
            ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.NOVA_SPEED.get()), pos.f_82479_, pos.f_82480_, pos.f_82481_, particleCount, (double)radius * 0.5, 0.25, (double)radius * 0.5, 0.0);
        });
    }

    @Override
    protected void doSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            Vec3 pos = context.getSource().getPos().orElse(player.m_20182_());
            player.f_19853_.m_6263_((Player)player, pos.f_82479_, pos.f_82480_, pos.f_82481_, ModSounds.NOVA_SPEED, SoundSource.PLAYERS, 0.2f, 1.0f);
            player.m_6330_(ModSounds.NOVA_SPEED, SoundSource.PLAYERS, 0.2f, 1.0f);
        });
    }

    private static void setAbilityData(LivingEntity livingEntity, int intervalTicks, UUID playerUUID) {
        CompoundTag abilityData = NovaSpeedAbility.getAbilityData(livingEntity);
        abilityData.m_128405_(TAG_INTERVAL_TICKS, intervalTicks);
        abilityData.m_128405_(TAG_REMAINING_INTERVAL_TICKS, 0);
        abilityData.m_128362_(TAG_PLAYER_UUID, playerUUID);
    }

    private static boolean isAbilityDataValid(CompoundTag data) {
        return data.m_128441_(TAG_INTERVAL_TICKS) && data.m_128441_(TAG_REMAINING_INTERVAL_TICKS) && data.m_128441_(TAG_PLAYER_UUID);
    }

    private static CompoundTag getAbilityData(LivingEntity livingEntity) {
        CompoundTag persistentData = livingEntity.getPersistentData();
        CompoundTag abilityData = persistentData.m_128469_(TAG_ABILITY_DATA);
        persistentData.m_128365_(TAG_ABILITY_DATA, (Tag)abilityData);
        return abilityData;
    }

    private static boolean decrementRemainingInterval(LivingEntity livingEntity) {
        boolean result = false;
        CompoundTag abilityData = NovaSpeedAbility.getAbilityData(livingEntity);
        int value = abilityData.m_128451_(TAG_REMAINING_INTERVAL_TICKS) - 1;
        if (value <= 0) {
            result = true;
            value = abilityData.m_128451_(TAG_INTERVAL_TICKS);
        }
        abilityData.m_128405_(TAG_REMAINING_INTERVAL_TICKS, value);
        return result;
    }

    @SubscribeEvent
    public static void on(LivingEvent.LivingUpdateEvent event) {
        ServerLevel serverLevel;
        LivingEntity livingEntity;
        block8: {
            block7: {
                livingEntity = event.getEntityLiving();
                Level level = livingEntity.m_183503_();
                if (!(level instanceof ServerLevel)) break block7;
                serverLevel = (ServerLevel)level;
                if (livingEntity.m_21023_((MobEffect)ModEffects.HYPOTHERMIA)) break block8;
            }
            return;
        }
        if (NovaSpeedAbility.decrementRemainingInterval(livingEntity)) {
            CompoundTag abilityData = NovaSpeedAbility.getAbilityData(livingEntity);
            if (!NovaSpeedAbility.isAbilityDataValid(abilityData)) {
                return;
            }
            UUID playerUUID = abilityData.m_128342_(TAG_PLAYER_UUID);
            ServerPlayer serverPlayer = serverLevel.m_142572_().m_6846_().m_11259_(playerUUID);
            if (serverPlayer == null) {
                return;
            }
            DamageSource srcPlayerAttack = DamageSource.m_19344_((Player)serverPlayer);
            if (livingEntity.m_6673_(srcPlayerAttack)) {
                return;
            }
            ActiveFlags.IS_EFFECT_ATTACKING.runIfNotSet(() -> {
                Vec3 movement = livingEntity.m_20184_();
                livingEntity.m_6469_(DamageSource.m_19344_((Player)serverPlayer), 1.0f);
                livingEntity.m_20256_(movement);
            });
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.durationTicks, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.amplifier, buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.damageIntervalTicks, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.durationTicks = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        this.amplifier = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        this.damageIntervalTicks = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.durationTicks).ifPresent(tag -> nbt.m_128365_("durationTicks", tag));
            Adapters.INT.writeNbt(this.amplifier).ifPresent(tag -> nbt.m_128365_("amplifier", tag));
            Adapters.INT.writeNbt(this.damageIntervalTicks).ifPresent(tag -> nbt.m_128365_("damageIntervalTicks", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.durationTicks = Adapters.INT.readNbt(nbt.m_128423_("durationTicks")).orElse(0);
        this.amplifier = Adapters.INT.readNbt(nbt.m_128423_("amplifier")).orElse(0);
        this.damageIntervalTicks = Adapters.INT.readNbt(nbt.m_128423_("damageIntervalTicks")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.durationTicks).ifPresent(element -> json.add("durationTicks", element));
            Adapters.INT.writeJson(this.amplifier).ifPresent(element -> json.add("amplifier", element));
            Adapters.INT.writeJson(this.damageIntervalTicks).ifPresent(element -> json.add("damageIntervalTicks", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.durationTicks = Adapters.INT.readJson(json.get("durationTicks")).orElse(0);
        this.amplifier = Adapters.INT.readJson(json.get("amplifier")).orElse(0);
        this.damageIntervalTicks = Adapters.INT.readJson(json.get("damageIntervalTicks")).orElse(0);
    }

    public static class HypothermiaEffect
    extends InfiniteDurationEffect {
        private static final String MOVEMENT_SPEED_UUID = "186fd101-ac04-4e84-9e1d-03ef06776bf7";
        private static final float MOVEMENT_SPEED_AMOUNT = -0.15f;

        public HypothermiaEffect(int color, ResourceLocation id) {
            super(MobEffectCategory.HARMFUL, color, id);
            this.m_19472_(Attributes.f_22279_, MOVEMENT_SPEED_UUID, -0.15f, AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
    }
}

