/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.PlayerStatEvent;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.init.ModEffects;
import iskallia.vault.skill.ability.effect.RampageAbility;
import iskallia.vault.skill.ability.effect.spi.AbstractRampageAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.calc.PlayerStat;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;

public class RampageLeechAbility
extends AbstractRampageAbility {
    private float leechPercent;

    public RampageLeechAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCostPerSecond, float damageIncrease, float leechPercent) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCostPerSecond, damageIncrease);
        this.leechPercent = leechPercent;
    }

    public RampageLeechAbility() {
    }

    public float getLeechPercent() {
        return this.leechPercent;
    }

    @Override
    protected Ability.ActionResult doToggle(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            if (this.isActive()) {
                int amplifier = (int)Mth.m_14036_((float)(this.getLeechPercent() * 100.0f), (float)0.0f, (float)100.0f);
                ModEffects.RAMPAGE_LEECH.addTo((LivingEntity)player, amplifier);
                return Ability.ActionResult.successCooldownDeferred();
            }
            player.m_21195_((MobEffect)ModEffects.RAMPAGE_LEECH);
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    public Ability.TickResult doInactiveTick(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            if (player.m_21023_((MobEffect)ModEffects.RAMPAGE_LEECH)) {
                player.m_21195_((MobEffect)ModEffects.RAMPAGE_LEECH);
            }
            return Ability.TickResult.PASS;
        }).orElse(Ability.TickResult.PASS);
    }

    @Override
    protected void doManaDepleted(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(entity -> entity.m_21195_((MobEffect)ModEffects.RAMPAGE_LEECH));
    }

    @Override
    public void onRemove(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(entity -> entity.m_21195_((MobEffect)ModEffects.RAMPAGE_LEECH));
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.leechPercent), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.leechPercent = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.leechPercent)).ifPresent(tag -> nbt.m_128365_("leechPercent", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.leechPercent = Adapters.FLOAT.readNbt(nbt.m_128423_("leechPercent")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.leechPercent)).ifPresent(element -> json.add("leechPercent", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.leechPercent = Adapters.FLOAT.readJson(json.get("leechPercent")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    static {
        ((PlayerStatEvent)CommonEvents.PLAYER_STAT.of(PlayerStat.LEECH).filter(data -> data.getEntity().m_21023_((MobEffect)ModEffects.RAMPAGE_LEECH))).register(RampageLeechAbility.class, data -> {
            int amplifier = data.getEntity().m_21124_((MobEffect)ModEffects.RAMPAGE_LEECH).m_19564_();
            float leechPercent = (float)amplifier / 100.0f;
            data.setValue(data.getValue() + leechPercent);
        });
    }

    public static class RampageLeechEffect
    extends RampageAbility.RampageEffect {
        public RampageLeechEffect(int color, ResourceLocation resourceLocation) {
            super(RampageLeechAbility.class, color, resourceLocation);
        }
    }
}

