/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.etching.EtchingGearAttributes;
import iskallia.vault.gear.etching.EtchingHelper;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.RetributionParticleMessage;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.InstantManaAbility;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import iskallia.vault.util.calc.ThornsHelper;
import iskallia.vault.util.damage.PlayerDamageHelper;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ShieldBashAbility
extends InstantManaAbility {
    private float damageDistance;
    private float percentageThornsDamageDealt;

    public ShieldBashAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, int manaCost, float damageRadius, float percentageThornsDamageDealt) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.damageDistance = damageRadius;
        this.percentageThornsDamageDealt = percentageThornsDamageDealt;
    }

    public ShieldBashAbility() {
    }

    public float getUnmodifiedDamageRadius() {
        return this.damageDistance;
    }

    public float getRadius(Entity attacker) {
        float realRadius = this.getUnmodifiedDamageRadius();
        if (attacker instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            realRadius = AreaOfEffectHelper.adjustAreaOfEffect(livingEntity, this, realRadius);
        }
        return realRadius;
    }

    public float getPercentageThornsDamageDealt() {
        return this.percentageThornsDamageDealt;
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            AtomicBoolean success = new AtomicBoolean(false);
            ActiveFlags.IS_AOE_ATTACKING.runIfNotSet(() -> {
                boolean allowPlayers = VaultUtils.getVault(player.f_19853_).map(VaultUtils::isPvPVault).orElse(false);
                ArrayList<LivingEntity> result = new ArrayList<LivingEntity>();
                EntityHelper.getEntitiesInRange((LevelAccessor)player.f_19853_, player.m_20182_(), 20.0f, entity -> EntityHelper.VAULT_TARGET_SELECTOR.test((Entity)entity) && (allowPlayers || !(entity instanceof Player)), result);
                result.remove(player);
                double thornsDamage = ThornsHelper.getAdditionalThornsFlatDamage((LivingEntity)player);
                float extraPercent = 0.0f;
                Optional etchingOpt = EtchingHelper.getEtchings((LivingEntity)player, EtchingGearAttributes.SHIELD_BASH_DAMAGE).stream().findFirst();
                if (etchingOpt.isPresent()) {
                    extraPercent = ((Float)((VaultGearAttributeInstance)etchingOpt.get()).getValue()).floatValue();
                }
                float baseAttack = (float)player.m_21133_(Attributes.f_22281_);
                AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)player);
                float fullDamageForward = this.damageDistance;
                fullDamageForward += fullDamageForward * (float)snapshot.getAttributeValue(ModGearAttributes.ON_HIT_AOE, VaultGearAttributeTypeMerger.intSum()).intValue();
                for (LivingEntity entity2 : result) {
                    float percentDamage = this.getPercentDamageDealt((Player)player, entity2, this.damageDistance);
                    if (!(percentDamage > 0.0f)) continue;
                    float scaledDamage = (float)(thornsDamage * (double)this.percentageThornsDamageDealt);
                    float bonus = baseAttack * extraPercent;
                    float mult = PlayerDamageHelper.getDamageMultiplier((Player)player, true, false);
                    entity2.m_6469_(DamageSource.m_19335_((Entity)player), (scaledDamage + bonus) * mult * percentDamage);
                }
                ModNetwork.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new RetributionParticleMessage(player.m_20182_().m_82520_(-0.5, 0.5, -0.5), fullDamageForward, player.m_6080_()));
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12347_, SoundSource.PLAYERS, 1.0f, 0.3f + player.m_21187_().nextFloat() * 0.2f);
                success.set(true);
            });
            if (success.get()) {
                return Ability.ActionResult.successCooldownImmediate();
            }
            return Ability.ActionResult.fail();
        }).orElse(Ability.ActionResult.fail());
    }

    private float getPercentDamageDealt(Player player, LivingEntity entity, float fullDamageForward) {
        boolean isInFullDamageRectangle;
        Vec3 viewVector = player.m_20252_(1.0f);
        double forwardX = viewVector.m_7096_();
        double forwardZ = viewVector.m_7094_();
        double d = Math.sqrt(forwardZ * forwardZ + forwardX * forwardX);
        double rightX = -(forwardZ /= d);
        double rightZ = forwardX /= d;
        double relativeX = entity.m_20185_() - player.m_20185_();
        double relativeZ = entity.m_20189_() - player.m_20189_();
        double distForward = relativeX * forwardX + relativeZ * forwardZ - (double)entity.m_20205_() / 2.0;
        double distRight = relativeX * rightX + relativeZ * rightZ;
        double d2 = distRight = distRight > 0.0 ? distRight - (double)entity.m_20205_() / 2.0 : distRight + (double)entity.m_20205_() / 2.0;
        if (distForward < 0.0 || distForward > (double)fullDamageForward + 0.5 || distRight < -1.0 || distRight > 1.0) {
            return 0.0f;
        }
        boolean bl = isInFullDamageRectangle = 0.0 <= distForward && distForward <= (double)fullDamageForward && -0.5 <= distRight && distRight <= 0.5;
        if (isInFullDamageRectangle) {
            return 1.0f;
        }
        boolean isHalfBehindForward = -0.5 <= distRight && distRight <= 0.5;
        boolean isOnTheAffectedSide = distForward <= (double)(fullDamageForward - 1.0f);
        return isHalfBehindForward || isOnTheAffectedSide ? 0.5f : 0.0f;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.damageDistance), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.percentageThornsDamageDealt), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.damageDistance = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.percentageThornsDamageDealt = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.damageDistance)).ifPresent(tag -> nbt.m_128365_("damageDistance", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.percentageThornsDamageDealt)).ifPresent(tag -> nbt.m_128365_("percentageThornsDamageDealt", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.damageDistance = Adapters.FLOAT.readNbt(nbt.m_128423_("damageDistance")).orElse(Float.valueOf(0.0f)).floatValue();
        this.percentageThornsDamageDealt = Adapters.FLOAT.readNbt(nbt.m_128423_("percentageThornsDamageDealt")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.damageDistance)).ifPresent(element -> json.add("damageDistance", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.percentageThornsDamageDealt)).ifPresent(element -> json.add("percentageThornsDamageDealt", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.damageDistance = Adapters.FLOAT.readJson(json.get("damageDistance")).orElse(Float.valueOf(0.0f)).floatValue();
        this.percentageThornsDamageDealt = Adapters.FLOAT.readJson(json.get("percentageThornsDamageDealt")).orElse(Float.valueOf(0.0f)).floatValue();
    }
}

