/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.math.Vector3f;
import iskallia.vault.client.particles.SphericalParticleOptions;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.entity.entity.PetEntity;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModParticles;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.InstantManaAbility;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.AABBHelper;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import iskallia.vault.util.calc.ThornsHelper;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.lang.invoke.LambdaMetafactory;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.EventPriority;

public class ShieldBashRetributionAbility
extends InstantManaAbility {
    private int chargeTime;
    private float damageRadius;
    private float damagePerStack;
    private final Map<EntityPredicate, Integer> stackage;
    private int timeLeft;
    private int stacks;

    public ShieldBashRetributionAbility() {
        this.stackage = new LinkedHashMap<EntityPredicate, Integer>();
    }

    public ShieldBashRetributionAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, int manaCost, int chargeTime, float damageRadius, float damagePerStack, Map<EntityPredicate, Integer> stackage) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.chargeTime = chargeTime;
        this.damageRadius = damageRadius;
        this.damagePerStack = damagePerStack;
        this.stackage = new LinkedHashMap<EntityPredicate, Integer>(stackage);
        this.timeLeft = 0;
        this.stacks = 0;
        this.sortStackage();
    }

    private void sortStackage() {
        List entries = this.stackage.entrySet().stream().sorted((e1, e2) -> Integer.compare((Integer)e2.getValue(), (Integer)e1.getValue())).toList();
        this.stackage.clear();
        for (Map.Entry entry : entries) {
            this.stackage.put((EntityPredicate)entry.getKey(), (Integer)entry.getValue());
        }
    }

    public int getChargeTime() {
        return this.chargeTime;
    }

    public float getUnmodifiedDamageRadius() {
        return this.damageRadius;
    }

    public float getRadius(Entity attacker) {
        float realRadius = this.getUnmodifiedDamageRadius();
        if (attacker instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            realRadius = AreaOfEffectHelper.adjustAreaOfEffect(livingEntity, this, realRadius);
        }
        return realRadius;
    }

    public float getDamagePerStack() {
        return this.damagePerStack;
    }

    public Map<EntityPredicate, Integer> getStackage() {
        return this.stackage;
    }

    @Override
    public void onTick(SkillContext context) {
        super.onTick(context);
        if (this.timeLeft <= 0) {
            this.stacks = 0;
            return;
        }
        --this.timeLeft;
        if (this.isUnlocked() && this.timeLeft > 0 && this.stacks > 0) {
            context.getSource().as(ServerPlayer.class).ifPresent(player -> {
                player.m_21195_(ModEffects.SHIELD_BASH_RETRIBUTION);
                player.m_7292_(new MobEffectInstance(ModEffects.SHIELD_BASH_RETRIBUTION, this.timeLeft, this.stacks - 1, true, false, true));
            });
        } else if (this.timeLeft == 0) {
            context.getSource().as(ServerPlayer.class).ifPresent(player -> {
                Vec3 pos = context.getSource().getPos().orElse(player.m_20182_());
                float thornsDamage = ThornsHelper.getAdditionalThornsFlatDamage((LivingEntity)player);
                float totalDamage = thornsDamage * this.getDamagePerStack() * (float)this.stacks;
                if (totalDamage > 0.0f) {
                    List<LivingEntity> targetEntities = this.getTargetEntities(player.f_19853_, (LivingEntity)player, pos);
                    DamageSource damageSource = DamageSource.m_19344_((Player)player);
                    for (LivingEntity entity : targetEntities) {
                        if (entity.m_6673_(damageSource)) continue;
                        float finalTotalDamage = totalDamage;
                        ActiveFlags.IS_AOE_ATTACKING.runIfNotSet(() -> entity.m_6469_(damageSource, finalTotalDamage));
                    }
                }
                player.m_183503_().m_8767_((ParticleOptions)new SphericalParticleOptions((ParticleType<SphericalParticleOptions>)((ParticleType)ModParticles.IMPLODE.get()), this.getRadius((Entity)player), new Vector3f(0.8f, 0.0f, 0.0f)), player.m_20185_(), player.m_20186_(), player.m_20189_(), 400, 0.0, 0.0, 0.0, 0.0);
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.MANA_SHIELD, SoundSource.PLAYERS, 0.2f, 0.2f);
                player.m_6330_(ModSounds.MANA_SHIELD, SoundSource.PLAYERS, 0.2f, 0.2f);
            });
            this.stacks = 0;
        }
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            this.timeLeft = this.chargeTime;
            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.MANA_SHIELD, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_6330_(ModSounds.MANA_SHIELD, SoundSource.PLAYERS, 1.0f, 1.0f);
            return Ability.ActionResult.successCooldownDelayed(this.chargeTime);
        }).orElse(Ability.ActionResult.fail());
    }

    private void onTakeDamage(Entity attacker, Entity attacked, float amount) {
        for (Map.Entry<EntityPredicate, Integer> entry : this.getStackage().entrySet()) {
            if (entry.getKey() == null || !entry.getKey().test(attacker)) continue;
            this.stacks += entry.getValue().intValue();
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected List<LivingEntity> getTargetEntities(Level world, LivingEntity attacker, Vec3 pos) {
        radius = this.getRadius((Entity)attacker);
        if (!(attacker instanceof ServerPlayer)) ** GOTO lbl-1000
        sPlayer = (ServerPlayer)attacker;
        if (VaultUtils.getVault(sPlayer.f_19853_).map((Function<Vault, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, isPvPVault(iskallia.vault.core.vault.Vault ), (Liskallia/vault/core/vault/Vault;)Ljava/lang/Boolean;)()).orElse(false).booleanValue()) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        allowPlayers = v0;
        return world.m_45971_(LivingEntity.class, TargetingConditions.m_148352_().m_26883_((double)radius).m_26888_((Predicate<LivingEntity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getTargetEntities$6(boolean net.minecraft.world.entity.LivingEntity ), (Lnet/minecraft/world/entity/LivingEntity;)Z)((boolean)allowPlayers)), attacker, AABBHelper.create(pos, radius));
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.chargeTime, buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.damageRadius), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.damagePerStack), buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.stackage.size(), buffer);
        this.stackage.forEach((filter, stacks) -> {
            Adapters.ENTITY_PREDICATE.writeBits((EntityPredicate)filter, buffer);
            Adapters.INT_SEGMENTED_3.writeBits(stacks, buffer);
        });
        Adapters.INT_SEGMENTED_7.writeBits(this.timeLeft, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.stacks, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.chargeTime = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        this.damageRadius = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.damagePerStack = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        this.stackage.clear();
        for (int i = 0; i < size; ++i) {
            this.stackage.put(Adapters.ENTITY_PREDICATE.readBits(buffer).orElse(null), (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow());
        }
        this.sortStackage();
        this.timeLeft = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        this.stacks = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.chargeTime).ifPresent(tag -> nbt.m_128365_("chargeTime", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.damageRadius)).ifPresent(tag -> nbt.m_128365_("damageRadius", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.damagePerStack)).ifPresent(tag -> nbt.m_128365_("damagePerStack", tag));
            Adapters.INT.writeNbt(this.timeLeft).ifPresent(tag -> nbt.m_128365_("timeLeft", tag));
            Adapters.INT.writeNbt(this.stacks).ifPresent(tag -> nbt.m_128365_("stacks", tag));
            ListTag stackage = new ListTag();
            this.stackage.forEach((filter, stacks) -> Adapters.ENTITY_PREDICATE.writeNbt((EntityPredicate)filter).ifPresent(tag1 -> Adapters.INT.writeNbt(stacks).ifPresent(tag2 -> {
                CompoundTag entry = new CompoundTag();
                entry.m_128365_("filter", tag1);
                entry.m_128365_("stacks", tag2);
                stackage.add((Object)entry);
            })));
            nbt.m_128365_("stackage", (Tag)stackage);
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.chargeTime = Adapters.INT.readNbt(nbt.m_128423_("chargeTime")).orElse(0);
        this.damageRadius = Adapters.FLOAT.readNbt(nbt.m_128423_("damageRadius")).orElse(Float.valueOf(0.0f)).floatValue();
        this.damagePerStack = Adapters.FLOAT.readNbt(nbt.m_128423_("damagePerStack")).orElse(Float.valueOf(0.0f)).floatValue();
        this.timeLeft = Adapters.INT.readNbt(nbt.m_128423_("timeLeft")).orElse(0);
        this.stacks = Adapters.INT.readNbt(nbt.m_128423_("stacks")).orElse(0);
        this.stackage.clear();
        Object object = nbt.m_128423_("stackage");
        if (object instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)object;
            for (String key : compound.m_128431_()) {
                Adapters.ENTITY_PREDICATE.readNbt((Tag)StringTag.m_129297_((String)key)).ifPresent(predicate -> Adapters.INT.readNbt(compound.m_128423_(key)).ifPresent(stacks -> this.stackage.put((EntityPredicate)predicate, (Integer)stacks)));
            }
        } else {
            object = nbt.m_128423_("stackage");
            if (object instanceof ListTag) {
                ListTag list = (ListTag)object;
                for (Tag tag : list) {
                    if (!(tag instanceof CompoundTag)) continue;
                    CompoundTag entry = (CompoundTag)tag;
                    Adapters.ENTITY_PREDICATE.readNbt(entry.m_128423_("filter")).ifPresent(predicate -> Adapters.INT.readNbt(entry.m_128423_("stacks")).ifPresent(stacks -> this.stackage.put((EntityPredicate)predicate, (Integer)stacks)));
                }
            }
        }
        this.sortStackage();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.chargeTime).ifPresent(tag -> json.add("chargeTime", tag));
            Adapters.FLOAT.writeJson(Float.valueOf(this.damageRadius)).ifPresent(tag -> json.add("damageRadius", tag));
            Adapters.FLOAT.writeJson(Float.valueOf(this.damagePerStack)).ifPresent(tag -> json.add("damagePerStack", tag));
            Adapters.INT.writeJson(this.timeLeft).ifPresent(tag -> json.add("timeLeft", tag));
            Adapters.INT.writeJson(this.stacks).ifPresent(tag -> json.add("stacks", tag));
            JsonArray stackage = new JsonArray();
            this.stackage.forEach((filter, stacks) -> Adapters.ENTITY_PREDICATE.writeJson((EntityPredicate)filter).ifPresent(tag1 -> Adapters.INT.writeJson(stacks).ifPresent(tag2 -> {
                JsonObject entry = new JsonObject();
                entry.add("filter", tag1);
                entry.add("stacks", tag2);
                stackage.add((JsonElement)entry);
            })));
            json.add("stackage", (JsonElement)stackage);
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.chargeTime = Adapters.INT.readJson(json.get("chargeTime")).orElse(0);
        this.damageRadius = Adapters.FLOAT.readJson(json.get("damageRadius")).orElse(Float.valueOf(0.0f)).floatValue();
        this.damagePerStack = Adapters.FLOAT.readJson(json.get("damagePerStack")).orElse(Float.valueOf(0.0f)).floatValue();
        this.timeLeft = Adapters.INT.readJson(json.get("timeLeft")).orElse(0);
        this.stacks = Adapters.INT.readJson(json.get("stacks")).orElse(0);
        this.stackage.clear();
        Object object = json.get("stackage");
        if (object instanceof JsonObject) {
            JsonObject object2 = (JsonObject)object;
            for (String key : object2.keySet()) {
                Adapters.ENTITY_PREDICATE.readJson((JsonElement)new JsonPrimitive(key)).ifPresent(predicate -> Adapters.INT.readJson(object2.get(key)).ifPresent(stacks -> this.stackage.put((EntityPredicate)predicate, (Integer)stacks)));
            }
        } else {
            object = json.get("stackage");
            if (object instanceof JsonArray) {
                JsonArray array = (JsonArray)object;
                for (int i = 0; i < array.size(); ++i) {
                    JsonElement jsonElement = array.get(i);
                    if (!(jsonElement instanceof JsonObject)) continue;
                    JsonObject entry = (JsonObject)jsonElement;
                    Adapters.ENTITY_PREDICATE.readJson(entry.get("filter")).ifPresent(predicate -> Adapters.INT.readJson(entry.get("stacks")).ifPresent(stacks -> this.stackage.put((EntityPredicate)predicate, (Integer)stacks)));
                }
            }
        }
        this.sortStackage();
    }

    private static /* synthetic */ boolean lambda$getTargetEntities$6(boolean allowPlayers, LivingEntity entity) {
        return (allowPlayers || !(entity instanceof Player)) && !(entity instanceof EternalEntity) && !(entity instanceof PetEntity);
    }

    static {
        CommonEvents.ENTITY_DAMAGE.register(ShieldBashRetributionAbility.class, EventPriority.HIGHEST, event -> {
            Entity patt3694$temp;
            if (event.getEntity().f_19853_.m_5776_() || event.getEntity().m_20194_() == null || !(event.getEntity() instanceof Player) || !((patt3694$temp = event.getSource().m_7639_()) instanceof LivingEntity)) {
                return;
            }
            LivingEntity attacker = (LivingEntity)patt3694$temp;
            PlayerAbilitiesData data = PlayerAbilitiesData.get(event.getEntity().m_20194_());
            for (ShieldBashRetributionAbility ability : data.getAbilities(event.getEntity().m_142081_()).getAll(ShieldBashRetributionAbility.class, Skill::isUnlocked)) {
                ability.onTakeDamage((Entity)attacker, event.getEntity(), event.getAmount());
            }
        });
    }
}

