/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.init.ModEffects;
import iskallia.vault.skill.ability.effect.spi.AbstractSmiteAbility;
import iskallia.vault.skill.ability.effect.spi.core.ToggleAbilityEffect;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.util.calc.PlayerStat;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class SmiteArchonAbility
extends AbstractSmiteAbility {
    private float additionalDurabilityWearReduction;

    public SmiteArchonAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCostPerSecond, float radius, int intervalTicks, float playerDamagePercentMin, float playerDamagePercentMax, int color, float additionalManaPerBolt, float additionalDurabilityWearReduction) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCostPerSecond, radius, intervalTicks, playerDamagePercentMin, playerDamagePercentMax, color, additionalManaPerBolt);
        this.additionalDurabilityWearReduction = additionalDurabilityWearReduction;
    }

    public float getAdditionalDurabilityWearReduction() {
        return this.additionalDurabilityWearReduction;
    }

    private static List<SmiteArchonAbility> getAll(LivingEntity livingEntity) {
        ServerPlayer player;
        ArrayList<SmiteArchonAbility> result = new ArrayList<SmiteArchonAbility>();
        if (!(livingEntity instanceof ServerPlayer) || (player = (ServerPlayer)livingEntity).m_21220_().stream().noneMatch(e -> e.m_19544_() == ModEffects.SMITE_ARCHON)) {
            return result;
        }
        AbilityTree abilities = PlayerAbilitiesData.get(player.m_183503_()).getAbilities((Player)player);
        return abilities.getAll(SmiteArchonAbility.class, Skill::isUnlocked);
    }

    public SmiteArchonAbility() {
    }

    @Override
    public ToggleAbilityEffect getEffect() {
        return ModEffects.SMITE_ARCHON;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.additionalDurabilityWearReduction), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.additionalDurabilityWearReduction = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.additionalDurabilityWearReduction)).ifPresent(tag -> nbt.m_128365_("additionalDurabilityWearReduction", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.additionalDurabilityWearReduction = Adapters.FLOAT.readNbt(nbt.m_128423_("additionalDurabilityWearReduction")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.additionalDurabilityWearReduction)).ifPresent(element -> json.add("additionalDurabilityWearReduction", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.additionalDurabilityWearReduction = Adapters.FLOAT.readJson(json.get("additionalDurabilityWearReduction")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    static {
        CommonEvents.PLAYER_STAT.of(PlayerStat.DURABILITY_WEAR_REDUCTION).register(SmiteArchonAbility.class, data -> SmiteArchonAbility.getAll(data.getEntity()).forEach(skill -> data.setValue(data.getValue() + skill.getAdditionalDurabilityWearReduction())));
    }
}

