/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import iskallia.vault.VaultMod;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.entity.entity.PetEntity;
import iskallia.vault.gear.etching.EtchingGearAttributes;
import iskallia.vault.gear.etching.EtchingHelper;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.StonefallParticleMessage;
import iskallia.vault.network.message.StunnedParticleMessage;
import iskallia.vault.skill.ability.effect.spi.AbstractStonefallAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.Throuple;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class StonefallAbility
extends AbstractStonefallAbility {
    public StonefallAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, int durationTicks, float knockbackMultiplier, float radius, float damageReduction) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost, durationTicks, knockbackMultiplier, radius, damageReduction);
    }

    public StonefallAbility() {
    }

    @Override
    protected boolean canDoAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> !player.m_21023_(ModEffects.STONEFALL) && super.canDoAction(context)).orElse(false);
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            player.m_7292_(new MobEffectInstance(ModEffects.STONEFALL, this.getDurationTicks((LivingEntity)player), 0, false, false, true));
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @SubscribeEvent
    public static void on(LivingFallEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        MobEffectInstance effectInstance = player.m_21124_(ModEffects.STONEFALL);
        if (effectInstance == null) {
            return;
        }
        float dist = event.getDistance();
        Level level = player.f_19853_;
        if (dist < 3.0f) {
            return;
        }
        AbilityTree abilities = PlayerAbilitiesData.get((ServerLevel)player.f_19853_).getAbilities((Player)player);
        for (StonefallAbility ability : abilities.getAll(StonefallAbility.class, Skill::isUnlocked)) {
            float radius = ability.getRadius((Entity)player) + Mth.m_14036_((float)(dist / 3.75f), (float)0.0f, (float)8.0f);
            List<LivingEntity> nearby = EntityHelper.getNearby((LevelAccessor)level, (Vec3i)player.m_142538_(), radius, LivingEntity.class);
            boolean allowPlayers = VaultUtils.getVault(player.f_19853_).map(VaultUtils::isPvPVault).orElse(false);
            nearby.removeIf(mob -> mob instanceof EternalEntity || mob instanceof PetEntity || !allowPlayers && mob instanceof ServerPlayer);
            nearby.remove(player);
            nearby.forEach(mob -> {
                float distTo = mob.m_20270_((Entity)player);
                float knockbackStrength = Mth.m_14036_((float)(dist / (12.0f + distTo)), (float)0.75f, (float)2.5f) * ability.getKnockbackMultiplier();
                EntityHelper.knockbackWithStrength(mob, (LivingEntity)player, knockbackStrength);
                EtchingHelper.getEtchings((LivingEntity)player, EtchingGearAttributes.STONE_FALL_STUN).stream().findFirst().ifPresent(stack -> {
                    float chance = ((Float)((Throuple)stack.getValue()).getFirst()).floatValue();
                    float duration = ((Float)((Throuple)stack.getValue()).getSecond()).floatValue();
                    if (player.f_19853_.f_46441_.nextFloat() < chance) {
                        String effectId = (String)((Throuple)stack.getValue()).getThird();
                        MobEffect effect = ModEffects.NO_AI;
                        if (!effectId.isEmpty() && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effectId))) == null) {
                            VaultMod.LOGGER.error("Unknown effect {} for StonefallStunEtching", (Object)effectId);
                            effect = ModEffects.NO_AI;
                        }
                        mob.m_7292_(new MobEffectInstance(effect, Mth.m_14143_((float)(duration * 20.0f)), 1, false, false){

                            public boolean m_19552_(LivingEntity livingEntity, Runnable onFinish) {
                                if (!livingEntity.m_21224_()) {
                                    ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new StunnedParticleMessage(new Vec3(livingEntity.m_20185_(), livingEntity.m_20186_() + (double)livingEntity.m_20206_(), livingEntity.m_20189_()), livingEntity.m_20205_()));
                                }
                                return super.m_19552_(livingEntity, onFinish);
                            }
                        });
                    }
                });
            });
            event.setDamageMultiplier(Mth.m_14036_((float)(1.0f - ability.getDamageReduction()), (float)0.0f, (float)1.0f));
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new StonefallParticleMessage(new Vec3(player.m_20185_(), player.m_20186_() + (double)0.15f, player.m_20189_()), radius));
            player.f_19853_.m_6263_((Player)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 0.1f, 0.75f);
            player.m_6330_(SoundEvents.f_11913_, SoundSource.PLAYERS, 0.1f, 0.75f);
        }
    }

    public static class StonefallEffect
    extends MobEffect {
        public StonefallEffect(int color, ResourceLocation resourceLocation) {
            super(MobEffectCategory.BENEFICIAL, color);
            this.setRegistryName(resourceLocation);
        }
    }
}

