/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.EntityStunnedEvent;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.entity.entity.PetEntity;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.network.message.StonefallFrostParticleMessage;
import iskallia.vault.skill.ability.effect.spi.AbstractStonefallAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class StonefallColdAbility
extends AbstractStonefallAbility {
    private int amplifier;
    private int freezeTicks;
    private int maxGlacialPrison;

    public StonefallColdAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, int durationTicks, float knockbackMultiplier, float radius, float damageReduction, int amplifier, int freezeTicks, int maxGlacialPrison) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost, durationTicks, knockbackMultiplier, radius, damageReduction);
        this.amplifier = amplifier;
        this.freezeTicks = freezeTicks;
        this.maxGlacialPrison = maxGlacialPrison;
    }

    public StonefallColdAbility() {
    }

    public int getMaxGlacialPrison() {
        return this.maxGlacialPrison;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public int getFreezeTicks() {
        return this.freezeTicks;
    }

    @Override
    protected boolean canDoAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> !player.m_21023_(ModEffects.STONEFALL_COLD) && super.canDoAction(context)).orElse(false);
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            player.m_7292_(new MobEffectInstance(ModEffects.STONEFALL_COLD, this.getDurationTicks((LivingEntity)player), 0, false, false, true));
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    protected void doParticles(SkillContext context) {
    }

    @SubscribeEvent
    public static void on(LivingFallEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        MobEffectInstance effectInstance = player.m_21124_(ModEffects.STONEFALL_COLD);
        if (effectInstance == null) {
            return;
        }
        float dist = event.getDistance();
        Level level = player.f_19853_;
        if (dist < 3.0f) {
            return;
        }
        AbilityTree abilities = PlayerAbilitiesData.get((ServerLevel)player.f_19853_).getAbilities((Player)player);
        for (StonefallColdAbility ability : abilities.getAll(StonefallColdAbility.class, Skill::isUnlocked)) {
            float radius = ability.getRadius((Entity)player) + Mth.m_14036_((float)(dist / 3.75f), (float)0.0f, (float)8.0f);
            int numberOfGlacialPrison = (int)Mth.m_14036_((float)(dist / 3.75f), (float)0.0f, (float)ability.getMaxGlacialPrison());
            AtomicInteger mobsGlacialPrisoned = new AtomicInteger(0);
            List<LivingEntity> nearby = EntityHelper.getNearby((LevelAccessor)level, (Vec3i)player.m_142538_(), radius, LivingEntity.class);
            boolean allowPlayers = VaultUtils.getVault(player.f_19853_).map(VaultUtils::isPvPVault).orElse(false);
            nearby.removeIf(mob -> mob instanceof EternalEntity || mob instanceof PetEntity || !allowPlayers && mob instanceof ServerPlayer);
            nearby.sort(Comparator.comparing(e -> Float.valueOf(e.m_20270_((Entity)player))));
            nearby.remove(player);
            nearby.forEach(mob -> {
                if (mobsGlacialPrisoned.get() < numberOfGlacialPrison) {
                    mobsGlacialPrisoned.incrementAndGet();
                    if (mob.m_21023_(ModEffects.GLACIAL_SHATTER)) {
                        mob.m_21195_(ModEffects.GLACIAL_SHATTER);
                    }
                    mob.m_7292_(new MobEffectInstance(ModEffects.GLACIAL_SHATTER, 30, ability.getAmplifier()));
                }
                EntityHelper.knockbackWithStrength(mob, (LivingEntity)player, 0.2f);
                mob.m_7292_(new MobEffectInstance(ModEffects.CHILLED, ability.getFreezeTicks(), ability.getAmplifier()));
                CommonEvents.ENTITY_STUNNED.invoke(new EntityStunnedEvent.Data((LivingEntity)player, (LivingEntity)mob));
            });
            event.setDamageMultiplier(Mth.m_14036_((float)(1.0f - ability.getDamageReduction()), (float)0.0f, (float)1.0f));
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new StonefallFrostParticleMessage(new Vec3(player.m_20185_(), player.m_20186_() + (double)0.15f, player.m_20189_()), radius));
            player.f_19853_.m_6263_((Player)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.NOVA_SPEED, SoundSource.PLAYERS, 0.2f, 1.0f);
            player.m_6330_(ModSounds.NOVA_SPEED, SoundSource.PLAYERS, 0.2f, 1.0f);
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.amplifier, buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.freezeTicks, buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.maxGlacialPrison, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.amplifier = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        this.freezeTicks = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        this.maxGlacialPrison = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.amplifier).ifPresent(tag -> nbt.m_128365_("amplifier", tag));
            Adapters.INT.writeNbt(this.freezeTicks).ifPresent(tag -> nbt.m_128365_("freezeTicks", tag));
            Adapters.INT.writeNbt(this.maxGlacialPrison).ifPresent(tag -> nbt.m_128365_("maxGlacialPrison", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.amplifier = Adapters.INT.readNbt(nbt.m_128423_("amplifier")).orElse(0);
        this.freezeTicks = Adapters.INT.readNbt(nbt.m_128423_("freezeTicks")).orElse(0);
        this.maxGlacialPrison = Adapters.INT.readNbt(nbt.m_128423_("maxGlacialPrison")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.amplifier).ifPresent(element -> json.add("amplifier", element));
            Adapters.INT.writeJson(this.freezeTicks).ifPresent(element -> json.add("freezeTicks", element));
            Adapters.INT.writeJson(this.maxGlacialPrison).ifPresent(element -> json.add("maxGlacialPrison", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.amplifier = Adapters.INT.readJson(json.get("amplifier")).orElse(0);
        this.freezeTicks = Adapters.INT.readJson(json.get("freezeTicks")).orElse(0);
        this.maxGlacialPrison = Adapters.INT.readJson(json.get("maxGlacialPrison")).orElse(0);
    }

    public static class StonefallColdEffect
    extends MobEffect {
        public StonefallColdEffect(int color, ResourceLocation resourceLocation) {
            super(MobEffectCategory.BENEFICIAL, color);
            this.setRegistryName(resourceLocation);
        }
    }
}

