/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.entity.entity.PetEntity;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.NovaParticleMessage;
import iskallia.vault.skill.ability.effect.spi.AbstractStonefallAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.calc.AbilityPowerHelper;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class StonefallSnowAbility
extends AbstractStonefallAbility {
    private float percentAbilityPowerDealt;

    public StonefallSnowAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, int durationTicks, float knockbackMultiplier, float radius, float damageReduction, float percentAbilityPowerDealt) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost, durationTicks, knockbackMultiplier, radius, damageReduction);
        this.percentAbilityPowerDealt = percentAbilityPowerDealt;
    }

    public StonefallSnowAbility() {
    }

    public float getDamageMultiplier() {
        return this.percentAbilityPowerDealt;
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            player.m_20095_();
            player.m_7292_(new MobEffectInstance(ModEffects.STONEFALL_SHOCKWAVE, this.getDurationTicks((LivingEntity)player), 0, false, false, true));
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    protected boolean canDoAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> !player.m_21023_(ModEffects.STONEFALL_SHOCKWAVE) && super.canDoAction(context)).orElse(false);
    }

    @SubscribeEvent
    public static void on(LivingFallEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        MobEffectInstance effectInstance = player.m_21124_(ModEffects.STONEFALL_SHOCKWAVE);
        if (effectInstance == null) {
            return;
        }
        AbilityTree abilities = PlayerAbilitiesData.get((ServerLevel)player.f_19853_).getAbilities((Player)player);
        float dist = event.getDistance();
        float percentAbilityPowerDealt = event.getDamageMultiplier();
        Level level = player.f_19853_;
        if (dist < 3.0f) {
            return;
        }
        DamageSource srcPlayerAttack = DamageSource.m_19344_((Player)player);
        for (StonefallSnowAbility ability : abilities.getAll(StonefallSnowAbility.class, Skill::isUnlocked)) {
            float radius = ability.getRadius((Entity)player) + Mth.m_14036_((float)(dist / 3.75f), (float)0.0f, (float)8.0f);
            List<LivingEntity> nearby = EntityHelper.getNearby((LevelAccessor)level, (Vec3i)player.m_142538_(), radius, LivingEntity.class);
            boolean allowPlayers = VaultUtils.getVault(player.f_19853_).map(VaultUtils::isPvPVault).orElse(false);
            nearby.removeIf(mob -> mob instanceof EternalEntity || mob instanceof PetEntity || !allowPlayers && mob instanceof ServerPlayer);
            nearby.removeIf(mob -> mob.m_6673_(srcPlayerAttack));
            nearby.remove(player);
            float damage = AbilityPowerHelper.getAbilityPower((Player)player) * ability.getDamageMultiplier();
            nearby.forEach(mob -> ActiveFlags.IS_AP_ATTACKING.runIfNotSet(() -> ActiveFlags.IS_AOE_ATTACKING.runIfNotSet(() -> {
                EntityHelper.knockbackWithStrength(mob, (LivingEntity)player, 0.2f);
                mob.m_6469_(srcPlayerAttack, damage);
            })));
            event.setDamageMultiplier(Mth.m_14036_((float)(1.0f - ability.getDamageReduction()), (float)0.0f, (float)1.0f));
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new NovaParticleMessage(new Vec3(player.m_20185_(), player.m_20186_() + (double)0.15f, player.m_20189_()), radius));
            player.f_19853_.m_6263_((Player)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 0.2f, 1.0f);
            player.m_6330_(SoundEvents.f_11913_, SoundSource.PLAYERS, 0.2f, 1.0f);
        }
    }

    private static int calculateFallDamage(LivingEntity fallingEntity, float pDistance, float pDamageMultiplier) {
        MobEffectInstance mobeffectinstance = fallingEntity.m_21124_(MobEffects.f_19603_);
        float f = mobeffectinstance == null ? 0.0f : (float)(mobeffectinstance.m_19564_() + 1);
        return Mth.m_14167_((float)((pDistance - 3.0f - f) * pDamageMultiplier));
    }

    @Override
    protected void doParticles(SkillContext context) {
    }

    @Override
    protected void doSound(SkillContext context) {
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.percentAbilityPowerDealt), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.percentAbilityPowerDealt = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.percentAbilityPowerDealt)).ifPresent(tag -> nbt.m_128365_("percentAbilityPowerDealt", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.percentAbilityPowerDealt = Adapters.FLOAT.readNbt(nbt.m_128423_("percentAbilityPowerDealt")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.percentAbilityPowerDealt)).ifPresent(element -> json.add("percentAbilityPowerDealt", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.percentAbilityPowerDealt = Adapters.FLOAT.readJson(json.get("percentAbilityPowerDealt")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public static class StonefallShockwaveEffect
    extends MobEffect {
        public StonefallShockwaveEffect(int color, ResourceLocation resourceLocation) {
            super(MobEffectCategory.BENEFICIAL, color);
            this.setRegistryName(resourceLocation);
        }
    }
}

