/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.entity.eternal.ActiveEternalData;
import iskallia.vault.entity.eternal.EternalData;
import iskallia.vault.entity.eternal.EternalHelper;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.InstantManaAbility;
import iskallia.vault.skill.archetype.archetype.CommanderArchetype;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.world.data.EternalsData;
import iskallia.vault.world.data.PlayerArchetypeData;
import iskallia.vault.world.data.ServerVaults;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SummonEternalAbility
extends InstantManaAbility {
    private static final UUID SPEED_INCREASE_ID = UUID.fromString("849085f9-1195-45fd-b219-243e7aec29e3");
    private int numberOfEternals;
    private int despawnTime;
    private float ancientChance;
    private boolean vaultOnly;

    public SummonEternalAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, int numberOfEternals, int despawnTime, float ancientChance, boolean vaultOnly) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.numberOfEternals = numberOfEternals;
        this.despawnTime = despawnTime;
        this.ancientChance = ancientChance;
        this.vaultOnly = vaultOnly;
    }

    public SummonEternalAbility() {
    }

    public int getNumberOfEternals() {
        return this.numberOfEternals;
    }

    public int getDespawnTime() {
        return this.despawnTime;
    }

    public float getAncientChance() {
        return this.ancientChance;
    }

    public boolean isVaultOnly() {
        return this.vaultOnly;
    }

    @Override
    protected boolean canDoAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            Level patt3130$temp;
            if (player.m_20193_().m_5776_() || !((patt3130$temp = player.m_20193_()) instanceof ServerLevel)) {
                return false;
            }
            ServerLevel serverLevel = (ServerLevel)patt3130$temp;
            EternalsData.EternalGroup playerEternals = EternalsData.get(serverLevel).getEternals((Player)player);
            if (playerEternals.getEternals().isEmpty()) {
                player.m_6352_((Component)new TextComponent("You have no eternals to summon.").m_130940_(ChatFormatting.RED), Util.f_137441_);
                return false;
            }
            if (ServerVaults.get(player.f_19853_).isEmpty()) {
                player.m_6352_((Component)new TextComponent("You can only summon eternals in the Vault!").m_130940_(ChatFormatting.RED), Util.f_137441_);
                return false;
            }
            return super.canDoAction(context);
        }).orElse(false);
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            Level patt4081$temp = player.m_20193_();
            if (!(patt4081$temp instanceof ServerLevel)) {
                return Ability.ActionResult.fail();
            }
            ServerLevel world = (ServerLevel)patt4081$temp;
            EternalsData.EternalGroup playerEternals = EternalsData.get(world).getEternals((Player)player);
            ArrayList<EternalData> eternals = new ArrayList<EternalData>();
            int count = this.getNumberOfEternals();
            for (int i = 0; i < count; ++i) {
                EternalData eternal = null;
                if (world.m_5822_().nextFloat() < this.getAncientChance()) {
                    eternal = playerEternals.getRandomAliveAncient(world.m_5822_(), eternalData -> !eternals.contains(eternalData) && !ActiveEternalData.getInstance().isEternalActive(eternalData.getId()));
                }
                if (eternal == null) {
                    eternal = playerEternals.getRandomAlive(world.m_5822_(), eternalData -> !eternals.contains(eternalData) && !ActiveEternalData.getInstance().isEternalActive(eternalData.getId()));
                }
                if (eternal == null) continue;
                eternals.add(eternal);
            }
            if (eternals.isEmpty()) {
                player.m_6352_((Component)new TextComponent("You have no (alive) eternals to summon.").m_130940_(ChatFormatting.RED), Util.f_137441_);
                return Ability.ActionResult.fail();
            }
            float speedIncrease = 0.0f;
            for (EternalData eternalData2 : eternals) {
                EternalEntity eternal = EternalHelper.spawnEternal((Level)world, eternalData2);
                eternal.m_7678_(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_146908_(), player.m_146909_());
                eternal.setDespawnTime(world.m_142572_().m_129921_() + this.getDespawnTime());
                eternal.setOwner(player.m_142081_());
                eternal.setEternalId(eternalData2.getId());
                eternal.m_7292_(new MobEffectInstance(MobEffects.f_19619_, Integer.MAX_VALUE, 0, true, false));
                if (speedIncrease > 0.0f && eternal.m_21204_().m_22171_(Attributes.f_22279_)) {
                    eternal.m_21051_(Attributes.f_22279_).m_22125_(new AttributeModifier(SPEED_INCREASE_ID, "Gear Speed Increase", (double)speedIncrease, AttributeModifier.Operation.MULTIPLY_BASE));
                }
                PlayerArchetypeData.get(world).getArchetypeContainer((Player)player).ifCurrentArchetype(CommanderArchetype.class, archetype -> archetype.applyToEternal(eternal));
                if (eternalData2.getAura() != null) {
                    eternal.setProvidedAura(eternalData2.getAura().getAuraName());
                }
                world.m_7967_((Entity)eternal);
            }
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    protected void doParticles(SkillContext context) {
    }

    @Override
    protected void doSound(SkillContext context) {
    }

    @SubscribeEvent
    public static void onDamage(LivingAttackEvent event) {
        Player player;
        LivingEntity damagedEntity = event.getEntityLiving();
        Entity dealerEntity = event.getSource().m_7639_();
        if (damagedEntity instanceof EternalEntity && dealerEntity instanceof Player && !(player = (Player)dealerEntity).m_7500_()) {
            event.setCanceled(true);
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT.writeBits(this.numberOfEternals, buffer);
        Adapters.INT.writeBits(this.despawnTime, buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.ancientChance), buffer);
        Adapters.BOOLEAN.writeBits(this.vaultOnly, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.numberOfEternals = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
        this.despawnTime = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
        this.ancientChance = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.vaultOnly = Adapters.BOOLEAN.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.numberOfEternals).ifPresent(tag -> nbt.m_128365_("numberOfEternals", tag));
            Adapters.INT.writeNbt(this.despawnTime).ifPresent(tag -> nbt.m_128365_("despawnTime", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.ancientChance)).ifPresent(tag -> nbt.m_128365_("ancientChance", tag));
            Adapters.BOOLEAN.writeNbt(this.vaultOnly).ifPresent(tag -> nbt.m_128365_("vaultOnly", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.numberOfEternals = Adapters.INT.readNbt(nbt.m_128423_("numberOfEternals")).orElse(0);
        this.despawnTime = Adapters.INT.readNbt(nbt.m_128423_("despawnTime")).orElse(0);
        this.ancientChance = Adapters.FLOAT.readNbt(nbt.m_128423_("ancientChance")).orElse(Float.valueOf(0.0f)).floatValue();
        this.vaultOnly = Adapters.BOOLEAN.readNbt(nbt.m_128423_("vaultOnly")).orElse(false);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.numberOfEternals).ifPresent(element -> json.add("numberOfEternals", element));
            Adapters.INT.writeJson(this.despawnTime).ifPresent(element -> json.add("despawnTime", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.ancientChance)).ifPresent(element -> json.add("ancientChance", element));
            Adapters.BOOLEAN.writeJson(this.vaultOnly).ifPresent(element -> json.add("vaultOnly", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.numberOfEternals = Adapters.INT.readJson(json.get("numberOfEternals")).orElse(0);
        this.despawnTime = Adapters.INT.readJson(json.get("despawnTime")).orElse(0);
        this.ancientChance = Adapters.FLOAT.readJson(json.get("ancientChance")).orElse(Float.valueOf(0.0f)).floatValue();
        this.vaultOnly = Adapters.BOOLEAN.readJson(json.get("vaultOnly")).orElse(false);
    }
}

