/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import com.mojang.math.Vector3f;
import iskallia.vault.client.particles.SphericalParticleOptions;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.entity.Targeting;
import iskallia.vault.entity.VaultBoss;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModParticles;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.effect.spi.AbstractTauntAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.AABBHelper;
import iskallia.vault.world.entity.ai.goal.GoalSelectorStack;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TauntCharmAbility
extends AbstractTauntAbility {
    public static final Predicate<LivingEntity> MONSTER_PREDICATE = entity -> entity.m_6095_().m_20674_() == MobCategory.MONSTER && entity instanceof Mob && !(entity instanceof VaultBoss) && !entity.m_21023_(ModEffects.TAUNT_CHARM) && !entity.m_21023_(ModEffects.TAUNT_REPEL_MOB) && !entity.m_19880_().contains("ethereal_immune");
    public static final Predicate<LivingEntity> LIVING_ENTITY_PREDICATE = entity -> !entity.m_21023_(ModEffects.TAUNT_CHARM) && !(entity instanceof Player) && TauntCharmAbility.doNotCharm(entity);
    private int maxCharmedMobs;
    private float percentAttackDamageDealt;
    private float speedMultiplier;
    public static final String TAG_ABILITY_DATA = "the_vault:Taunt_Charm";
    public static final String TAG_PLAYER_UUID = "playerUUID";
    public static final String TAG_PERCENT_PLAYER_DAMAGE = "percentAttackDamageDealt";
    private static final UUID MOVEMENT_SPEED_MODIFIER_UUID;

    private static boolean doNotCharm(LivingEntity entity) {
        if (entity.m_6095_().getRegistryName() == null) {
            return true;
        }
        String entityName = entity.m_6095_().getRegistryName().toString();
        if (entityName.contains("target_dummy")) {
            return true;
        }
        return entityName.contains("armor_stand");
    }

    public TauntCharmAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float radius, int durationTicks, int maxCharmedMobs, float percentAttackDamageDealt, float speedMultiplier) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost, radius, durationTicks);
        this.maxCharmedMobs = maxCharmedMobs;
        this.percentAttackDamageDealt = percentAttackDamageDealt;
        this.speedMultiplier = speedMultiplier;
    }

    public TauntCharmAbility() {
    }

    public int getMaxCharmedMobs() {
        return this.maxCharmedMobs;
    }

    public float getPercentPlayerDamage() {
        return this.percentAttackDamageDealt;
    }

    public float getSpeedMultiplier() {
        return this.speedMultiplier;
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            float radius = this.getRadius((Player)player);
            List nearbyMobs = player.f_19853_.m_45971_(Mob.class, TargetingConditions.m_148352_().m_26883_((double)radius).m_26888_(MONSTER_PREDICATE), (LivingEntity)player, AABBHelper.create(player.m_20182_(), radius));
            Collections.shuffle(nearbyMobs);
            int maxCharmedMobs = this.getMaxCharmedMobs();
            for (Mob mob : nearbyMobs) {
                if (maxCharmedMobs <= 0) break;
                if (!player.m_142582_((Entity)mob)) continue;
                mob.m_6710_(null);
                Brain brain = mob.m_6274_();
                brain.m_21936_(MemoryModuleType.f_26372_);
                brain.m_21936_(MemoryModuleType.f_26334_);
                brain.m_21936_(MemoryModuleType.f_26335_);
                mob.m_7292_(new MobEffectInstance(ModEffects.TAUNT_CHARM, this.getDurationTicks((LivingEntity)player), 0, false, true, false));
                TauntCharmAbility.setAbilityData(mob, player.m_142081_(), this.getPercentPlayerDamage());
                TauntCharmAbility.applySpeedModifier(mob, 0.5f + this.getSpeedMultiplier());
                --maxCharmedMobs;
            }
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    protected void doParticles(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            Level patt7080$temp = player.f_19853_;
            if (patt7080$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt7080$temp;
                Vec3 position = player.m_20182_();
                serverLevel.m_8767_((ParticleOptions)new SphericalParticleOptions((ParticleType<SphericalParticleOptions>)((ParticleType)ModParticles.TAUNT_CHARM_EFFECT_RANGE.get()), this.getRadius((Player)player), new Vector3f(1.0f, 1.0f, 1.0f)), position.f_82479_, position.f_82480_, position.f_82481_, 200, 0.0, 0.0, 0.0, 0.0);
            }
        });
    }

    @Override
    protected void doSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            SoundEvent sound = ModSounds.TAUNT_CHARM;
            player.f_19853_.m_6263_((Player)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), sound, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_6330_(sound, SoundSource.PLAYERS, 1.0f, 1.0f);
        });
    }

    public static void setAbilityData(Mob mob, UUID playerUUID, float percentAttackDamageDealt) {
        CompoundTag persistentData = mob.getPersistentData();
        CompoundTag abilityData = new CompoundTag();
        abilityData.m_128362_(TAG_PLAYER_UUID, playerUUID);
        abilityData.m_128350_(TAG_PERCENT_PLAYER_DAMAGE, percentAttackDamageDealt);
        persistentData.m_128365_(TAG_ABILITY_DATA, (Tag)abilityData);
    }

    public static void removeAbilityData(Mob mob) {
        CompoundTag persistentData = mob.getPersistentData();
        persistentData.m_128473_(TAG_ABILITY_DATA);
    }

    public static CompoundTag getAbilityData(Mob mob) {
        CompoundTag persistentData = mob.getPersistentData();
        if (!persistentData.m_128425_(TAG_ABILITY_DATA, 10)) {
            return null;
        }
        CompoundTag abilityData = persistentData.m_128469_(TAG_ABILITY_DATA);
        if (!abilityData.m_128425_(TAG_PLAYER_UUID, 11) || !abilityData.m_128425_(TAG_PERCENT_PLAYER_DAMAGE, 5)) {
            return null;
        }
        return abilityData;
    }

    private static void applySpeedModifier(Mob mob, float value) {
        AttributeInstance attributeInstance = mob.m_21051_(Attributes.f_22279_);
        if (attributeInstance == null) {
            return;
        }
        attributeInstance.m_22118_(new AttributeModifier(MOVEMENT_SPEED_MODIFIER_UUID, "Charmed mob movement speed bonus", (double)value, AttributeModifier.Operation.MULTIPLY_BASE));
    }

    private static void removeSpeedModifier(Mob mob) {
        AttributeInstance attributeInstance = mob.m_21051_(Attributes.f_22279_);
        if (attributeInstance == null) {
            return;
        }
        attributeInstance.m_22120_(MOVEMENT_SPEED_MODIFIER_UUID);
    }

    @SubscribeEvent
    public static void on(LivingAttackEvent event) {
        Level level = event.getEntity().m_183503_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        CompoundTag abilityData = TauntCharmAbility.getAbilityData(mob);
        if (abilityData == null) {
            return;
        }
        UUID playerUUID = abilityData.m_128342_(TAG_PLAYER_UUID);
        Player player = serverLevel.m_46003_(playerUUID);
        if (player == null) {
            return;
        }
        AttributeInstance attributeInstance = player.m_21051_(Attributes.f_22281_);
        if (attributeInstance == null) {
            return;
        }
        LivingEntity targetEntity = event.getEntityLiving();
        if (targetEntity instanceof ServerPlayer) {
            return;
        }
        DamageSource srcPlayerAttack = DamageSource.m_19344_((Player)player);
        if (targetEntity.m_6673_(srcPlayerAttack)) {
            return;
        }
        ActiveFlags.IS_CHARMED_ATTACKING.runIfNotSet(() -> {
            float percentAttackDamageDealt = abilityData.m_128457_(TAG_PERCENT_PLAYER_DAMAGE);
            float damage = (float)player.m_21133_(Attributes.f_22281_) * percentAttackDamageDealt;
            Vec3 movement = targetEntity.m_20184_();
            targetEntity.m_6469_(srcPlayerAttack, damage);
            targetEntity.m_20256_(new Vec3(movement.f_82479_, Math.min(movement.f_82480_ + 0.2, 0.2), movement.f_82481_));
        });
        event.setCanceled(true);
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.maxCharmedMobs, buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.percentAttackDamageDealt), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.speedMultiplier), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.maxCharmedMobs = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        this.percentAttackDamageDealt = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.speedMultiplier = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.maxCharmedMobs).ifPresent(tag -> nbt.m_128365_("maxCharmedMobs", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.percentAttackDamageDealt)).ifPresent(tag -> nbt.m_128365_(TAG_PERCENT_PLAYER_DAMAGE, tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.speedMultiplier)).ifPresent(tag -> nbt.m_128365_("speedMultiplier", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.maxCharmedMobs = Adapters.INT.readNbt(nbt.m_128423_("maxCharmedMobs")).orElse(0);
        this.percentAttackDamageDealt = Adapters.FLOAT.readNbt(nbt.m_128423_(TAG_PERCENT_PLAYER_DAMAGE)).orElse(Float.valueOf(0.0f)).floatValue();
        this.speedMultiplier = Adapters.FLOAT.readNbt(nbt.m_128423_("speedMultiplier")).orElse(Float.valueOf(0.5f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.maxCharmedMobs).ifPresent(element -> json.add("maxCharmedMobs", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.percentAttackDamageDealt)).ifPresent(element -> json.add(TAG_PERCENT_PLAYER_DAMAGE, element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.speedMultiplier)).ifPresent(element -> json.add("speedMultiplier", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.maxCharmedMobs = Adapters.INT.readJson(json.get("maxCharmedMobs")).orElse(0);
        this.percentAttackDamageDealt = Adapters.FLOAT.readJson(json.get(TAG_PERCENT_PLAYER_DAMAGE)).orElse(Float.valueOf(0.0f)).floatValue();
        this.speedMultiplier = Adapters.FLOAT.readJson(json.get("speedMultiplier")).orElse(Float.valueOf(0.5f)).floatValue();
    }

    static {
        Targeting.addIgnoredTargetOverride((attacker, target) -> {
            LivingEntity livingEntity;
            return attacker.m_21023_(ModEffects.TAUNT_CHARM) && (target instanceof Player || target instanceof LivingEntity && (livingEntity = (LivingEntity)target).m_21023_(ModEffects.TAUNT_CHARM));
        });
        Targeting.addForcedTargetOverride((attacker, target) -> {
            LivingEntity livingEntity;
            return attacker.m_21023_(ModEffects.TAUNT_CHARM) && target instanceof LivingEntity && LIVING_ENTITY_PREDICATE.test(livingEntity = (LivingEntity)target);
        });
        MOVEMENT_SPEED_MODIFIER_UUID = UUID.fromString("46489b0a-0cfd-4e51-87ab-d656b8a13db2");
    }

    public static class CharmedAttackTargetGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        public CharmedAttackTargetGoal(Mob mob) {
            super(mob, LivingEntity.class, 10, true, false, LIVING_ENTITY_PREDICATE);
        }

        public void m_8056_() {
            super.m_8056_();
            this.f_26137_ = this.f_26135_.m_5448_();
        }
    }

    public static class TauntCharmMobEffect
    extends MobEffect {
        public TauntCharmMobEffect(int color, ResourceLocation id) {
            super(MobEffectCategory.NEUTRAL, color);
            this.setRegistryName(id);
        }

        @ParametersAreNonnullByDefault
        public void m_6385_(LivingEntity livingEntity, AttributeMap attributeMap, int amplifier) {
            if (!(livingEntity instanceof Mob)) {
                return;
            }
            Mob mob = (Mob)livingEntity;
            GoalSelector goalSelector = mob.f_21346_;
            if (!(goalSelector instanceof GoalSelectorStack)) {
                return;
            }
            GoalSelectorStack goalSelectorStack = (GoalSelectorStack)goalSelector;
            goalSelectorStack.pushGoalSet();
            mob.f_21346_.m_25352_(0, (Goal)new CharmedAttackTargetGoal(mob));
        }

        @ParametersAreNonnullByDefault
        public void m_6386_(LivingEntity livingEntity, AttributeMap attributeMap, int amplifier) {
            if (!(livingEntity instanceof Mob)) {
                return;
            }
            Mob mob = (Mob)livingEntity;
            GoalSelector goalSelector = mob.f_21346_;
            if (!(goalSelector instanceof GoalSelectorStack)) {
                return;
            }
            GoalSelectorStack goalSelectorStack = (GoalSelectorStack)goalSelector;
            goalSelectorStack.popGoalSet();
            TauntCharmAbility.removeAbilityData(mob);
            TauntCharmAbility.removeSpeedModifier(mob);
        }
    }
}

