/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.entity.Targeting;
import iskallia.vault.entity.VaultBoss;
import iskallia.vault.entity.champion.IChampionPacifyEffect;
import iskallia.vault.entity.entity.CrabEntity;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.effect.spi.AbstractTauntAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.AABBHelper;
import java.awt.Color;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TauntRepelAbility
extends AbstractTauntAbility {
    protected static final Predicate<LivingEntity> MONSTER_PREDICATE = entity -> (entity.m_6095_().m_20674_() == MobCategory.MONSTER || entity instanceof CrabEntity) && !(entity instanceof VaultBoss) && !entity.m_21023_(ModEffects.TAUNT_CHARM);
    private float repelForce;

    public TauntRepelAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float radius, int durationTicks, float repelForce) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost, radius, durationTicks);
        this.repelForce = repelForce;
    }

    public TauntRepelAbility() {
    }

    public float getRepelForce() {
        return this.repelForce;
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            player.m_21195_(ModEffects.TAUNT_REPEL_PLAYER);
            player.m_7292_(new MobEffectInstance(ModEffects.TAUNT_REPEL_PLAYER, this.getDurationTicks((LivingEntity)player), 0, false, false, true));
            float radius = this.getRadius((Player)player);
            List nearbyMobs = player.f_19853_.m_45971_(Mob.class, TargetingConditions.m_148352_().m_26883_((double)radius).m_26888_(MONSTER_PREDICATE), (LivingEntity)player, AABBHelper.create(player.m_20182_(), radius));
            for (Mob mob : nearbyMobs) {
                if (!player.m_142582_((Entity)mob)) continue;
                mob.m_6710_(null);
                mob.m_21195_(ModEffects.TAUNT_REPEL_MOB);
                mob.m_7292_(new MobEffectInstance(ModEffects.TAUNT_REPEL_MOB, this.getDurationTicks((LivingEntity)player), 0, false, true, false));
                Vec3 force = mob.m_20182_().m_82546_(player.m_20182_()).m_82541_().m_82490_((double)this.repelForce);
                mob.m_5997_(force.f_82479_, force.f_82480_, force.f_82481_);
                mob.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
                mob.m_21573_().m_26573_();
            }
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    protected void doParticles(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            float radius = this.getRadius((Player)player);
            int particleCount = (int)Mth.m_14008_((double)(Math.pow(radius, 2.0) * 3.1415927410125732 * 100.0), (double)50.0, (double)400.0);
            ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123762_, player.m_20185_(), player.m_20186_(), player.m_20189_(), particleCount / 2, (double)radius * 0.5, 0.5, (double)radius * 0.5, 0.0);
            ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123746_, player.m_20185_(), player.m_20186_(), player.m_20189_(), particleCount / 2, (double)radius * 0.5, 0.5, (double)radius * 0.5, 0.0);
            AreaEffectCloud areaEffectCloud = new AreaEffectCloud(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_());
            areaEffectCloud.m_19718_((LivingEntity)player);
            areaEffectCloud.m_19712_(radius);
            areaEffectCloud.m_19732_(-0.5f);
            areaEffectCloud.m_19740_(0);
            areaEffectCloud.m_19734_(4);
            areaEffectCloud.m_19722_(Potions.f_43598_);
            areaEffectCloud.m_19738_(-areaEffectCloud.m_19743_() / (float)areaEffectCloud.m_19748_());
            areaEffectCloud.m_19714_(Color.BLACK.getRGB());
            areaEffectCloud.m_19724_((ParticleOptions)ParticleTypes.f_123762_);
            player.f_19853_.m_7967_((Entity)areaEffectCloud);
        });
    }

    @Override
    protected void doSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            player.f_19853_.m_6263_((Player)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.TAUNT_REPEL, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_6330_(ModSounds.TAUNT_REPEL, SoundSource.PLAYERS, 1.0f, 1.0f);
        });
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.repelForce), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.repelForce = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.repelForce)).ifPresent(tag -> nbt.m_128365_("repelForce", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.repelForce = Adapters.FLOAT.readNbt(nbt.m_128423_("repelForce")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.repelForce)).ifPresent(element -> json.add("repelForce", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.repelForce = Adapters.FLOAT.readJson(json.get("repelForce")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public static class FearGoal
    extends Goal {
        private static final int RANGE = 1024;
        private static final int RADIUS = 10;
        private static final int VERTICAL_DISTANCE = 4;
        protected final PathfinderMob mob;
        protected final double speedModifier;
        protected double posX;
        protected double posY;
        protected double posZ;

        public FearGoal(PathfinderMob mob, double speedModifier) {
            this.mob = mob;
            this.speedModifier = speedModifier;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.mob.m_20184_().m_82556_() > 2.0) {
                return false;
            }
            Player nearestPlayer = this.mob.f_19853_.m_45946_(TargetingConditions.m_148353_().m_26883_(1024.0).m_26888_(entity -> entity.m_21023_(ModEffects.TAUNT_REPEL_PLAYER)), (LivingEntity)this.mob);
            Vec3 randomPos = null;
            for (int i = 0; i < 10 && (randomPos = nearestPlayer == null ? DefaultRandomPos.m_148403_((PathfinderMob)this.mob, (int)10, (int)4) : DefaultRandomPos.m_148407_((PathfinderMob)this.mob, (int)10, (int)4, (Vec3)nearestPlayer.m_20182_())) == null; ++i) {
            }
            if (randomPos == null) {
                return false;
            }
            this.posX = randomPos.f_82479_;
            this.posY = randomPos.f_82480_;
            this.posZ = randomPos.f_82481_;
            return true;
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26519_(this.posX, this.posY, this.posZ, this.speedModifier);
        }

        public boolean m_8045_() {
            if (this.mob.m_21573_().m_26571_() && this.m_8036_()) {
                this.m_8056_();
            }
            return true;
        }

        public boolean m_6767_() {
            return false;
        }
    }

    public static class TauntRepelMobEffect
    extends MobEffect
    implements IChampionPacifyEffect {
        private static final double SPEED_MODIFIER = 1.25;

        public TauntRepelMobEffect(int color, ResourceLocation resourceLocation) {
            super(MobEffectCategory.NEUTRAL, color);
            this.setRegistryName(resourceLocation);
        }

        public boolean m_6584_(int duration, int amplifier) {
            return true;
        }

        public void m_6742_(@Nonnull LivingEntity livingEntity, int amplifier) {
            if (livingEntity instanceof Mob) {
                Mob mob = (Mob)livingEntity;
                mob.f_21345_.m_25386_().filter(wrappedGoal -> !(wrappedGoal.m_26015_() instanceof FearGoal)).forEach(WrappedGoal::m_8041_);
                mob.m_6710_(null);
                for (WrappedGoal wrappedGoal2 : mob.f_21345_.m_148105_()) {
                    Goal goal = wrappedGoal2.m_26015_();
                    if (!(goal instanceof FearGoal)) continue;
                    FearGoal fearGoal = (FearGoal)goal;
                    if (wrappedGoal2.m_7620_() || !fearGoal.m_8036_()) continue;
                    wrappedGoal2.m_8056_();
                    break;
                }
            }
        }

        @ParametersAreNonnullByDefault
        public void m_6385_(LivingEntity livingEntity, AttributeMap attributeMap, int amplifier) {
            super.m_6385_(livingEntity, attributeMap, amplifier);
            if (livingEntity instanceof PathfinderMob) {
                PathfinderMob mob = (PathfinderMob)livingEntity;
                mob.f_21345_.m_25352_(0, (Goal)new FearGoal(mob, 1.25));
            }
        }

        @ParametersAreNonnullByDefault
        public void m_6386_(LivingEntity livingEntity, AttributeMap attributeMap, int amplifier) {
            super.m_6386_(livingEntity, attributeMap, amplifier);
            if (livingEntity instanceof PathfinderMob) {
                PathfinderMob mob = (PathfinderMob)livingEntity;
                mob.f_21345_.m_148105_().stream().filter(wrappedGoal -> wrappedGoal.m_26015_() instanceof FearGoal).toList().forEach(wrappedGoal -> {
                    wrappedGoal.m_8041_();
                    mob.f_21345_.m_25363_(wrappedGoal.m_26015_());
                });
            }
        }

        static {
            Targeting.addIgnoredTargetOverride((attacker, entity) -> {
                LivingEntity le;
                return entity instanceof LivingEntity && (le = (LivingEntity)entity).m_21023_(ModEffects.TAUNT_REPEL_MOB);
            });
        }
    }

    public static class TauntRepelPlayerEffect
    extends MobEffect {
        public TauntRepelPlayerEffect(int color, ResourceLocation resourceLocation) {
            super(MobEffectCategory.NEUTRAL, color);
            this.setRegistryName(resourceLocation);
        }
    }
}

