/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.entity.entity.ToxicGrenadeEntity;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.InstantManaAbility;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.calc.AbilityPowerHelper;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import iskallia.vault.util.calc.EffectDurationHelper;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class ToxicGrenadeAbility
extends InstantManaAbility {
    private float percentAbilityPowerDealt;
    private float radius;
    private int durationTicks;
    private int poisonTicks;
    private float throwPower = 1.0f;

    public ToxicGrenadeAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float percentAbilityPowerDealt, float radius, int durationTicks, int poisonTicks, float throwPower) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.percentAbilityPowerDealt = percentAbilityPowerDealt;
        this.radius = radius;
        this.durationTicks = durationTicks;
        this.poisonTicks = poisonTicks;
        this.throwPower = throwPower;
    }

    public ToxicGrenadeAbility() {
    }

    public float getPercentAbilityPowerDealt() {
        return this.percentAbilityPowerDealt;
    }

    public float getUnmodifiedRadius() {
        return this.radius;
    }

    public float getRadius(ServerPlayer player) {
        return AreaOfEffectHelper.adjustAreaOfEffect((LivingEntity)player, this, this.radius);
    }

    public int getDurationTicksUnmodified() {
        return this.durationTicks;
    }

    public int getDurationTicks() {
        return this.durationTicks;
    }

    public int getPoisonTicksUnmodified() {
        return this.poisonTicks;
    }

    public int getPoisonTicks(ServerPlayer player) {
        int modifiedTicks = EffectDurationHelper.adjustEffectDurationFloor((LivingEntity)player, this.poisonTicks);
        return Math.max(20, modifiedTicks);
    }

    private float getAbilityPower(ServerPlayer player) {
        return AbilityPowerHelper.getAbilityPower((Player)player) * this.getPercentAbilityPowerDealt();
    }

    public float getThrowPower() {
        return this.throwPower;
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            ToxicGrenadeEntity grenade = new ToxicGrenadeEntity(player.f_19853_, (LivingEntity)player, this.getAbilityPower((ServerPlayer)player), this.getRadius((ServerPlayer)player), this.getDurationTicks(), this.getPoisonTicks((ServerPlayer)player));
            grenade.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, this.throwPower, 0.0f);
            player.f_19853_.m_7967_((Entity)grenade);
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.percentAbilityPowerDealt), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.radius), buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.durationTicks, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.poisonTicks, buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.throwPower), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.percentAbilityPowerDealt = Adapters.FLOAT.readBits(buffer).orElse(Float.valueOf(0.0f)).floatValue();
        this.radius = Adapters.FLOAT.readBits(buffer).orElse(Float.valueOf(0.0f)).floatValue();
        this.durationTicks = Adapters.INT_SEGMENTED_3.readBits(buffer).orElse(0);
        this.poisonTicks = Adapters.INT_SEGMENTED_3.readBits(buffer).orElse(0);
        this.throwPower = Adapters.FLOAT.readBits(buffer).orElse(Float.valueOf(1.0f)).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.percentAbilityPowerDealt)).ifPresent(t -> nbt.m_128365_("percentAbilityPowerDealt", t));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.radius)).ifPresent(t -> nbt.m_128365_("radius", t));
            Adapters.INT.writeNbt(this.durationTicks).ifPresent(t -> nbt.m_128365_("durationTicks", t));
            Adapters.INT.writeNbt(this.poisonTicks).ifPresent(t -> nbt.m_128365_("poisonTicks", t));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.throwPower)).ifPresent(t -> nbt.m_128365_("throwPower", t));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.percentAbilityPowerDealt = Adapters.FLOAT.readNbt(nbt.m_128423_("percentAbilityPowerDealt")).orElse(Float.valueOf(0.0f)).floatValue();
        this.radius = Adapters.FLOAT.readNbt(nbt.m_128423_("radius")).orElse(Float.valueOf(0.0f)).floatValue();
        this.durationTicks = Adapters.INT.readNbt(nbt.m_128423_("durationTicks")).orElse(0);
        this.poisonTicks = Adapters.INT.readNbt(nbt.m_128423_("poisonTicks")).orElse(0);
        this.throwPower = Adapters.FLOAT.readNbt(nbt.m_128423_("throwPower")).orElse(Float.valueOf(1.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.percentAbilityPowerDealt)).ifPresent(e -> json.add("percentAbilityPowerDealt", e));
            Adapters.FLOAT.writeJson(Float.valueOf(this.radius)).ifPresent(e -> json.add("radius", e));
            Adapters.INT.writeJson(this.durationTicks).ifPresent(e -> json.add("durationTicks", e));
            Adapters.INT.writeJson(this.poisonTicks).ifPresent(e -> json.add("poisonTicks", e));
            Adapters.FLOAT.writeJson(Float.valueOf(this.throwPower)).ifPresent(e -> json.add("throwPower", e));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.percentAbilityPowerDealt = Adapters.FLOAT.readJson(json.get("percentAbilityPowerDealt")).orElse(Float.valueOf(0.0f)).floatValue();
        this.radius = Adapters.FLOAT.readJson(json.get("radius")).orElse(Float.valueOf(0.0f)).floatValue();
        this.durationTicks = Adapters.INT.readJson(json.get("durationTicks")).orElse(0);
        this.poisonTicks = Adapters.INT.readJson(json.get("poisonTicks")).orElse(0);
        this.throwPower = Adapters.FLOAT.readJson(json.get("throwPower")).orElse(Float.valueOf(1.0f)).floatValue();
    }
}

