/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.ability.effect.VeinMinerAbility;
import iskallia.vault.util.OverlevelEnchantHelper;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class VeinMinerDurabilityAbility
extends VeinMinerAbility {
    private int additionalUnbreakingLevel;

    public VeinMinerDurabilityAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, int blockLimit, int additionalUnbreakingLevel) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, blockLimit);
        this.additionalUnbreakingLevel = additionalUnbreakingLevel;
    }

    public VeinMinerDurabilityAbility() {
    }

    public int getAdditionalUnbreakingLevel() {
        return this.additionalUnbreakingLevel;
    }

    @Override
    protected ItemStack getVeinMiningItemProxy(Player player) {
        ItemStack itemStackCopy = super.getVeinMiningItemProxy(player).m_41777_();
        return OverlevelEnchantHelper.increaseUnbreakingBy(itemStackCopy, this.getAdditionalUnbreakingLevel());
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.additionalUnbreakingLevel, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.additionalUnbreakingLevel = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.additionalUnbreakingLevel).ifPresent(tag -> nbt.m_128365_("additionalUnbreakingLevel", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.additionalUnbreakingLevel = Adapters.INT.readNbt(nbt.m_128423_("additionalUnbreakingLevel")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.additionalUnbreakingLevel).ifPresent(element -> json.add("additionalUnbreakingLevel", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.additionalUnbreakingLevel = Adapters.INT.readJson(json.get("additionalUnbreakingLevel")).orElse(0);
    }
}

