/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.spi;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.ability.effect.spi.core.InstantManaAbility;
import iskallia.vault.util.calc.AbilityPowerHelper;
import java.util.Optional;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public abstract class AbstractChainLightningAbility
extends InstantManaAbility {
    private float percentAbilityPowerDealtMin;
    private float percentAbilityPowerDealtMax;
    private float throwPower;
    private float distance;
    private float chainRange;

    public AbstractChainLightningAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float percentAbilityPowerDealtMin, float percentAbilityPowerDealtMax, float throwPower, float distance, float chainRange) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.percentAbilityPowerDealtMin = percentAbilityPowerDealtMin;
        this.percentAbilityPowerDealtMax = percentAbilityPowerDealtMax;
        this.throwPower = throwPower;
        this.distance = distance;
        this.chainRange = chainRange;
    }

    protected AbstractChainLightningAbility() {
    }

    public float getRandomDamagePercent(ServerPlayer player) {
        return Mth.m_14068_((Random)player.m_21187_(), (float)this.percentAbilityPowerDealtMin, (float)this.percentAbilityPowerDealtMax);
    }

    public float getPercentAbilityPowerDealtMin() {
        return this.percentAbilityPowerDealtMin;
    }

    public float getPercentAbilityPowerDealtMax() {
        return this.percentAbilityPowerDealtMax;
    }

    public float getThrowPower() {
        return this.throwPower;
    }

    public float getDistance() {
        return this.distance;
    }

    public float getChainRange() {
        return this.chainRange;
    }

    public float getAbilityPower(ServerPlayer player) {
        return AbilityPowerHelper.getAbilityPower((Player)player);
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.percentAbilityPowerDealtMin), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.percentAbilityPowerDealtMax), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.throwPower), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.distance), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.chainRange), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.percentAbilityPowerDealtMin = Adapters.FLOAT.readBits(buffer).orElse(Float.valueOf(0.0f)).floatValue();
        this.percentAbilityPowerDealtMax = Adapters.FLOAT.readBits(buffer).orElse(Float.valueOf(0.0f)).floatValue();
        this.throwPower = Adapters.FLOAT.readBits(buffer).orElse(Float.valueOf(1.0f)).floatValue();
        this.distance = Adapters.FLOAT.readBits(buffer).orElse(Float.valueOf(10.0f)).floatValue();
        this.chainRange = Adapters.FLOAT.readBits(buffer).orElse(Float.valueOf(3.0f)).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.percentAbilityPowerDealtMin)).ifPresent(t -> nbt.m_128365_("percentAbilityPowerDealtMin", t));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.percentAbilityPowerDealtMax)).ifPresent(t -> nbt.m_128365_("percentAbilityPowerDealtMax", t));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.throwPower)).ifPresent(t -> nbt.m_128365_("throwPower", t));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.distance)).ifPresent(t -> nbt.m_128365_("distance", t));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.chainRange)).ifPresent(t -> nbt.m_128365_("chainRange", t));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.percentAbilityPowerDealtMin = Adapters.FLOAT.readNbt(nbt.m_128423_("percentAbilityPowerDealtMin")).orElse(Float.valueOf(0.0f)).floatValue();
        this.percentAbilityPowerDealtMax = Adapters.FLOAT.readNbt(nbt.m_128423_("percentAbilityPowerDealtMax")).orElse(Float.valueOf(0.0f)).floatValue();
        this.throwPower = Adapters.FLOAT.readNbt(nbt.m_128423_("throwPower")).orElse(Float.valueOf(1.0f)).floatValue();
        this.distance = Adapters.FLOAT.readNbt(nbt.m_128423_("distance")).orElse(Float.valueOf(10.0f)).floatValue();
        this.chainRange = Adapters.FLOAT.readNbt(nbt.m_128423_("chainRange")).orElse(Float.valueOf(3.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.percentAbilityPowerDealtMin)).ifPresent(e -> json.add("percentAbilityPowerDealtMin", e));
            Adapters.FLOAT.writeJson(Float.valueOf(this.percentAbilityPowerDealtMax)).ifPresent(e -> json.add("percentAbilityPowerDealtMax", e));
            Adapters.FLOAT.writeJson(Float.valueOf(this.throwPower)).ifPresent(e -> json.add("throwPower", e));
            Adapters.FLOAT.writeJson(Float.valueOf(this.distance)).ifPresent(e -> json.add("distance", e));
            Adapters.FLOAT.writeJson(Float.valueOf(this.chainRange)).ifPresent(e -> json.add("chainRange", e));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.percentAbilityPowerDealtMin = Adapters.FLOAT.readJson(json.get("percentAbilityPowerDealtMin")).orElse(Float.valueOf(0.0f)).floatValue();
        this.percentAbilityPowerDealtMax = Adapters.FLOAT.readJson(json.get("percentAbilityPowerDealtMax")).orElse(Float.valueOf(0.0f)).floatValue();
        this.throwPower = Adapters.FLOAT.readJson(json.get("throwPower")).orElse(Float.valueOf(1.0f)).floatValue();
        this.distance = Adapters.FLOAT.readJson(json.get("distance")).orElse(Float.valueOf(10.0f)).floatValue();
        this.chainRange = Adapters.FLOAT.readJson(json.get("chainRange")).orElse(Float.valueOf(3.0f)).floatValue();
    }
}

