/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.spi;

import com.google.gson.JsonObject;
import com.mojang.math.Vector3f;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.NovaParticleMessage;
import iskallia.vault.skill.ability.effect.spi.core.InstantManaAbility;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.ServerScheduler;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import iskallia.vault.util.damage.PlayerDamageHelper;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public abstract class AbstractEarthquakeAbility
extends InstantManaAbility {
    protected float radius;
    protected float percentAttackDamageDealt;
    protected float knockbackStrengthMultiplier;
    protected float blockDestructionChance;
    protected float blockReplacementChance;
    private static final double VERTICAL_RANGE = 2.0;
    private static final int BLOCKS_PER_TICK = 40;

    public AbstractEarthquakeAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float radius, float percentAttackDamageDealt, float knockbackStrengthMultiplier, float blockDestructionChance, float blockReplacementChance) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.radius = radius;
        this.percentAttackDamageDealt = percentAttackDamageDealt;
        this.knockbackStrengthMultiplier = knockbackStrengthMultiplier;
        this.blockDestructionChance = blockDestructionChance;
        this.blockReplacementChance = blockReplacementChance;
    }

    public AbstractEarthquakeAbility() {
    }

    public float getUnmodifiedRadius() {
        return this.radius;
    }

    public float getRadius(Entity attacker) {
        float realRadius = this.getUnmodifiedRadius();
        if (attacker instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            realRadius = AreaOfEffectHelper.adjustAreaOfEffect(livingEntity, this, realRadius);
        }
        return realRadius;
    }

    public float getPercentAttackDamageDealt() {
        return this.percentAttackDamageDealt;
    }

    public float getKnockbackStrengthMultiplier() {
        return this.knockbackStrengthMultiplier;
    }

    public float getBlockDestructionChance() {
        return this.blockDestructionChance;
    }

    public float getBlockReplacementChance() {
        return this.blockReplacementChance;
    }

    /*
     * Unable to fully structure code
     */
    protected List<LivingEntity> getTargetEntities(Level level, LivingEntity attacker, Vec3 center) {
        radius = this.getRadius((Entity)attacker);
        if (!(attacker instanceof ServerPlayer)) ** GOTO lbl-1000
        s = (ServerPlayer)attacker;
        if (VaultUtils.getVault(s.f_19853_).map((Function<Vault, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, isPvPVault(iskallia.vault.core.vault.Vault ), (Liskallia/vault/core/vault/Vault;)Ljava/lang/Boolean;)()).orElse(false).booleanValue()) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        allowPlayers = v0;
        r2 = radius * radius;
        return level.m_6443_(LivingEntity.class, this.createEffectAABB(center, radius), (Predicate<LivingEntity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getTargetEntities$0(net.minecraft.world.entity.LivingEntity boolean net.minecraft.world.phys.Vec3 double net.minecraft.world.entity.LivingEntity ), (Lnet/minecraft/world/entity/LivingEntity;)Z)((LivingEntity)attacker, (boolean)allowPlayers, (Vec3)center, (double)r2));
    }

    private AABB createEffectAABB(Vec3 pos, float radius) {
        return new AABB(pos.f_82479_ - (double)radius, pos.f_82480_ - 2.0, pos.f_82481_ - (double)radius, pos.f_82479_ + (double)radius, pos.f_82480_ + 2.0, pos.f_82481_ + (double)radius);
    }

    protected float getAttackDamage(ServerPlayer player) {
        float baseAttackDamage = (float)player.m_21133_(Attributes.f_22281_);
        float attackDamagePercentageIncrease = AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)player).getAttributeValue(ModGearAttributes.DAMAGE_INCREASE, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        float increase = baseAttackDamage * attackDamagePercentageIncrease;
        float damage = (baseAttackDamage += increase) * this.getPercentAttackDamageDealt();
        return damage * PlayerDamageHelper.getDamageMultiplier((Player)player, true, false);
    }

    public void triggerExplosion(ServerPlayer player, Vec3 pos, boolean extra) {
        List<LivingEntity> targetEntities = this.getTargetEntities(player.f_19853_, (LivingEntity)player, pos);
        float attackDamage = this.getAttackDamage(player);
        DamageSource damageSource = DamageSource.m_19344_((Player)player);
        float radius = this.getRadius((Entity)player);
        for (LivingEntity entity : targetEntities) {
            if (entity.m_6673_(damageSource)) continue;
            float distanceModifier = this.getDamageModifier(radius, player.m_20270_((Entity)entity));
            ActiveFlags.IS_AP_ATTACKING.runIfNotSet(() -> ActiveFlags.IS_AOE_ATTACKING.runIfNotSet(() -> {
                if (entity.m_6469_(damageSource, attackDamage * distanceModifier) && !Mth.m_14033_((float)this.getKnockbackStrengthMultiplier(), (float)0.0f)) {
                    double dz;
                    double dx = pos.f_82479_ - entity.m_20185_();
                    if (dx * dx + (dz = pos.f_82481_ - entity.m_20189_()) * dz < 1.0E-4) {
                        dx = (Math.random() - Math.random()) * 0.01;
                        dz = (Math.random() - Math.random()) * 0.01;
                    }
                    entity.m_147240_((double)(0.4f * this.getKnockbackStrengthMultiplier()), dx, dz);
                }
            }));
        }
        this.processBlocks(player.f_19853_, pos, radius);
        player.f_19853_.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11913_, SoundSource.BLOCKS, 1.0f, 0.5f);
        Level level = player.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.showExplosionParticles(serverLevel, pos, radius);
            if (extra) {
                ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new NovaParticleMessage(new Vec3(pos.f_82479_, pos.f_82480_ + (double)0.15f, pos.f_82481_), radius));
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123813_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void processBlocks(Level level, Vec3 pos, float radius) {
        Optional<Vault> vaultOpt = VaultUtils.getVault(level);
        if (vaultOpt.isEmpty()) {
            return;
        }
        boolean herald = VaultUtils.isHeraldVault(vaultOpt.get());
        if (herald) {
            return;
        }
        if (this.blockDestructionChance <= 0.0f) {
            return;
        }
        int radiusInt = Mth.m_14167_((float)radius);
        BlockPos center = new BlockPos(pos);
        ArrayList<BlockPos> toProcess = new ArrayList<BlockPos>();
        for (int x = -radiusInt; x <= radiusInt; ++x) {
            for (int z = -radiusInt; z <= radiusInt; ++z) {
                for (int y = -2; y <= 0; ++y) {
                    BlockPos blockPos = center.m_142082_(x, y, z).m_7949_();
                    double distance = Math.sqrt(blockPos.m_123331_((Vec3i)center));
                    if (distance > (double)radius) continue;
                    float distanceFactor = 1.0f - (float)(distance / (double)radius);
                    if (!(level.m_5822_().nextFloat() < this.blockDestructionChance * distanceFactor)) continue;
                    toProcess.add(blockPos);
                }
            }
        }
        int index = 0;
        for (BlockPos blockPos : toProcess) {
            int delay = index++ / 40;
            ServerScheduler.INSTANCE.schedule(delay, () -> {
                BlockState state = level.m_8055_(blockPos);
                if (!state.m_60795_() && state.m_60800_((BlockGetter)level, blockPos) >= 0.0f && state.m_60800_((BlockGetter)level, blockPos) < 50.0f) {
                    level.m_7471_(blockPos, false);
                    if (level.m_5822_().nextFloat() < this.blockReplacementChance) {
                        double dist = Math.sqrt(blockPos.m_123331_((Vec3i)center));
                        float distFactor = 1.0f - (float)(dist / (double)radius);
                        if ((double)distFactor > 0.8) {
                            level.m_7731_(blockPos, Blocks.f_50546_.m_49966_(), 3);
                        } else if ((double)distFactor > 0.6) {
                            level.m_7731_(blockPos, Blocks.f_50493_.m_49966_(), 3);
                        } else if ((double)distFactor > 0.4 && blockPos.m_123342_() - center.m_123342_() <= 0) {
                            level.m_7731_(blockPos, Blocks.f_49994_.m_49966_(), 3);
                        }
                    }
                }
            });
        }
    }

    protected void showExplosionParticles(ServerLevel level, Vec3 pos, float radius) {
        int i;
        int particleCount = (int)(radius * radius * 5.0f);
        for (i = 0; i < particleCount; ++i) {
            BlockState blockState;
            double distance = level.f_46441_.nextDouble() * (double)radius;
            double angle = level.f_46441_.nextDouble() * 2.0 * Math.PI;
            double x = pos.f_82479_ + distance * Math.cos(angle);
            double z = pos.f_82481_ + distance * Math.sin(angle);
            BlockPos blockPos = new BlockPos(x, pos.f_82480_ - 1.0, z);
            while (blockPos.m_123342_() > level.m_141937_() && level.m_46859_(blockPos)) {
                blockPos = blockPos.m_7495_();
            }
            if (blockPos.m_123342_() <= level.m_141937_() || (blockState = level.m_8055_(blockPos)).m_60795_()) continue;
            level.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.6f, 0.5f, 0.4f), 1.5f), x, (double)blockPos.m_123342_() + 0.5, z, 5, 0.0, 0.5, 0.0, 0.2);
            if (level.f_46441_.nextFloat() < 0.3f) {
                level.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), x, (double)blockPos.m_123342_() + 0.5, z, 8, 0.2, 0.5, 0.2, 0.3);
            }
            if (!(level.f_46441_.nextFloat() < 0.2f)) continue;
            level.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), x, (double)blockPos.m_123342_() + 0.5, z, 8, 0.3, 1.2, 0.3, 1.0);
        }
        for (i = 0; i < 3; ++i) {
            float pitch = 0.5f + level.f_46441_.nextFloat() * 0.2f;
            level.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11913_, SoundSource.BLOCKS, 0.5f, pitch);
        }
    }

    protected float getDamageModifier(float radius, float dist) {
        if (dist >= 0.0f && dist < radius / 5.0f * 1.0f) {
            return 1.0f;
        }
        if (dist >= radius / 5.0f * 1.0f && dist < radius / 5.0f * 2.0f) {
            return 0.8f;
        }
        if (dist >= radius / 5.0f * 2.0f && dist < radius / 5.0f * 3.0f) {
            return 0.6f;
        }
        if (dist >= radius / 5.0f * 3.0f && dist < radius / 5.0f * 4.0f) {
            return 0.4f;
        }
        if (dist >= radius / 5.0f * 4.0f) {
            return 0.2f;
        }
        return 0.2f;
    }

    @Override
    protected void doParticles(SkillContext context) {
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.radius), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.percentAttackDamageDealt), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.knockbackStrengthMultiplier), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.blockDestructionChance), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.blockReplacementChance), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.radius = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.percentAttackDamageDealt = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.knockbackStrengthMultiplier = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.blockDestructionChance = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.blockReplacementChance = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.radius)).ifPresent(tag -> nbt.m_128365_("radius", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.percentAttackDamageDealt)).ifPresent(tag -> nbt.m_128365_("percentAttackDamageDealt", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.knockbackStrengthMultiplier)).ifPresent(tag -> nbt.m_128365_("knockbackStrengthMultiplier", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.blockDestructionChance)).ifPresent(tag -> nbt.m_128365_("blockDestructionChance", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.blockReplacementChance)).ifPresent(tag -> nbt.m_128365_("blockReplacementChance", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.radius = Adapters.FLOAT.readNbt(nbt.m_128423_("radius")).orElse(Float.valueOf(0.0f)).floatValue();
        this.percentAttackDamageDealt = Adapters.FLOAT.readNbt(nbt.m_128423_("percentAttackDamageDealt")).orElse(Float.valueOf(0.0f)).floatValue();
        this.knockbackStrengthMultiplier = Adapters.FLOAT.readNbt(nbt.m_128423_("knockbackStrengthMultiplier")).orElse(Float.valueOf(0.0f)).floatValue();
        this.blockDestructionChance = Adapters.FLOAT.readNbt(nbt.m_128423_("blockDestructionChance")).orElse(Float.valueOf(0.0f)).floatValue();
        this.blockReplacementChance = Adapters.FLOAT.readNbt(nbt.m_128423_("blockReplacementChance")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.radius)).ifPresent(element -> json.add("radius", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.percentAttackDamageDealt)).ifPresent(element -> json.add("percentAttackDamageDealt", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.knockbackStrengthMultiplier)).ifPresent(element -> json.add("knockbackStrengthMultiplier", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.blockDestructionChance)).ifPresent(element -> json.add("blockDestructionChance", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.blockReplacementChance)).ifPresent(element -> json.add("blockReplacementChance", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.radius = Adapters.FLOAT.readJson(json.get("radius")).orElse(Float.valueOf(0.0f)).floatValue();
        this.percentAttackDamageDealt = Adapters.FLOAT.readJson(json.get("percentAttackDamageDealt")).orElse(Float.valueOf(0.0f)).floatValue();
        this.knockbackStrengthMultiplier = Adapters.FLOAT.readJson(json.get("knockbackStrengthMultiplier")).orElse(Float.valueOf(0.0f)).floatValue();
        this.blockDestructionChance = Adapters.FLOAT.readJson(json.get("blockDestructionChance")).orElse(Float.valueOf(0.0f)).floatValue();
        this.blockReplacementChance = Adapters.FLOAT.readJson(json.get("blockReplacementChance")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    private static /* synthetic */ boolean lambda$getTargetEntities$0(LivingEntity attacker, boolean allowPlayers, Vec3 center, double r2, LivingEntity entity) {
        if (entity == attacker) {
            return false;
        }
        if (!allowPlayers && entity instanceof Player) {
            return false;
        }
        return entity.m_20275_(center.f_82479_, center.f_82480_, center.f_82481_) <= r2;
    }
}

