/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.spi;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.ToggleManaAbility;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import iskallia.vault.util.calc.CooldownHelper;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractFarmerAbility
extends ToggleManaAbility {
    private int tickDelay;
    private int horizontalRange;
    private int verticalRange;
    private int tick;

    public AbstractFarmerAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCostPerSecond, int tickDelay, int horizontalRange, int verticalRange) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCostPerSecond);
        this.tickDelay = tickDelay;
        this.horizontalRange = horizontalRange;
        this.verticalRange = verticalRange;
        this.tick = 0;
    }

    protected AbstractFarmerAbility() {
    }

    public int getTickDelay() {
        return this.tickDelay;
    }

    public int getHorizontalRange() {
        return this.horizontalRange;
    }

    public int getVerticalRange() {
        return this.verticalRange;
    }

    @Override
    public Ability.TickResult doActiveTick(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            if (this.tick > 0) {
                --this.tick;
                return super.doActiveTick(context);
            }
            this.tick = CooldownHelper.adjustCooldown((LivingEntity)player, this, this.getTickDelay());
            Ability.TickResult result = super.doActiveTick(context);
            if (result != Ability.TickResult.COOLDOWN) {
                this.doGrow((ServerPlayer)player, (ServerLevel)player.f_19853_);
            }
            return result;
        }).orElse(Ability.TickResult.PASS);
    }

    protected void doGrow(ServerPlayer player, ServerLevel world) {
        Block block;
        BlockPos playerPos = player.m_142538_();
        int originalHorizontalRange = this.getHorizontalRange();
        int originalVerticalRange = this.getVerticalRange();
        int horizontalRange = originalHorizontalRange;
        int verticalRange = originalVerticalRange;
        horizontalRange = AreaOfEffectHelper.adjustAreaOfEffectRound((LivingEntity)player, this, horizontalRange);
        verticalRange = AreaOfEffectHelper.adjustAreaOfEffectRound((LivingEntity)player, this, verticalRange);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        ArrayList<BlockPos> candidateList = new ArrayList<BlockPos>();
        for (int x = -horizontalRange; x <= horizontalRange; ++x) {
            for (int z = -horizontalRange; z <= horizontalRange; ++z) {
                for (int y = -verticalRange; y <= verticalRange; ++y) {
                    mutableBlockPos.m_122178_(playerPos.m_123341_() + x, playerPos.m_123342_() + y, playerPos.m_123343_() + z);
                    BlockState blockState = world.m_8055_((BlockPos)mutableBlockPos);
                    block = blockState.m_60734_();
                    if (!this.canGrowBlock(world, (BlockPos)mutableBlockPos, block, blockState)) continue;
                    candidateList.add(new BlockPos((Vec3i)mutableBlockPos));
                }
            }
        }
        if (!candidateList.isEmpty()) {
            int executionAttempts = Math.max(1, originalHorizontalRange * originalVerticalRange / (horizontalRange * verticalRange));
            for (int i = 0; i < executionAttempts; ++i) {
                BlockPos pos = (BlockPos)candidateList.get(world.m_5822_().nextInt(candidateList.size()));
                BlockState state = world.m_8055_(pos);
                block = world.m_8055_(pos).m_60734_();
                this.doGrowBlock(player, world, pos, block, state);
            }
        }
    }

    protected abstract boolean canGrowBlock(ServerLevel var1, BlockPos var2, Block var3, BlockState var4);

    protected abstract void doGrowBlock(ServerPlayer var1, ServerLevel var2, BlockPos var3, Block var4, BlockState var5);

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.tickDelay, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.horizontalRange, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.verticalRange, buffer);
        Adapters.INT.writeBits(this.tick, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.tickDelay = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        this.horizontalRange = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        this.verticalRange = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        this.tick = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.tickDelay).ifPresent(tag -> nbt.m_128365_("tickDelay", tag));
            Adapters.INT.writeNbt(this.horizontalRange).ifPresent(tag -> nbt.m_128365_("horizontalRange", tag));
            Adapters.INT.writeNbt(this.verticalRange).ifPresent(tag -> nbt.m_128365_("verticalRange", tag));
            Adapters.INT.writeNbt(this.tick).ifPresent(tag -> nbt.m_128365_("tick", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.tickDelay = Adapters.INT.readNbt(nbt.m_128423_("tickDelay")).orElse(0);
        this.horizontalRange = Adapters.INT.readNbt(nbt.m_128423_("horizontalRange")).orElse(0);
        this.verticalRange = Adapters.INT.readNbt(nbt.m_128423_("verticalRange")).orElse(0);
        this.tick = Adapters.INT.readNbt(nbt.m_128423_("tick")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.tickDelay).ifPresent(element -> json.add("tickDelay", element));
            Adapters.INT.writeJson(this.horizontalRange).ifPresent(element -> json.add("horizontalRange", element));
            Adapters.INT.writeJson(this.verticalRange).ifPresent(element -> json.add("verticalRange", element));
            Adapters.INT.writeJson(this.tick).ifPresent(element -> json.add("tick", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.tickDelay = Adapters.INT.readJson(json.get("tickDelay")).orElse(0);
        this.horizontalRange = Adapters.INT.readJson(json.get("horizontalRange")).orElse(0);
        this.verticalRange = Adapters.INT.readJson(json.get("verticalRange")).orElse(0);
        this.tick = Adapters.INT.readJson(json.get("tick")).orElse(0);
    }
}

