/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.spi;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.ability.effect.spi.core.InstantManaAbility;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.calc.AbilityPowerHelper;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public abstract class AbstractFireballAbility
extends InstantManaAbility {
    private float percentAbilityPowerDealt;
    private float radius;

    public AbstractFireballAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float percentAbilityPowerDealt, float radius) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.percentAbilityPowerDealt = percentAbilityPowerDealt;
        this.radius = radius;
    }

    protected AbstractFireballAbility() {
    }

    public float getPercentAbilityPowerDealt() {
        return this.percentAbilityPowerDealt;
    }

    public float getRadius() {
        return this.radius;
    }

    public float getAbilityPower(ServerPlayer player) {
        return AbilityPowerHelper.getAbilityPower((Player)player) * this.getPercentAbilityPowerDealt();
    }

    @Override
    protected void doParticles(SkillContext context) {
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.percentAbilityPowerDealt), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.radius), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.percentAbilityPowerDealt = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.radius = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.percentAbilityPowerDealt)).ifPresent(tag -> nbt.m_128365_("percentAbilityPowerDealt", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.radius)).ifPresent(tag -> nbt.m_128365_("radius", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.percentAbilityPowerDealt = Adapters.FLOAT.readNbt(nbt.m_128423_("percentAbilityPowerDealt")).orElse(Float.valueOf(1.0f)).floatValue();
        this.radius = Adapters.FLOAT.readNbt(nbt.m_128423_("radius")).orElse(Float.valueOf(1.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.percentAbilityPowerDealt)).ifPresent(element -> json.add("percentAbilityPowerDealt", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.radius)).ifPresent(element -> json.add("radius", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.percentAbilityPowerDealt = Adapters.FLOAT.readJson(json.get("percentAbilityPowerDealt")).orElse(Float.valueOf(1.0f)).floatValue();
        this.radius = Adapters.FLOAT.readJson(json.get("radius")).orElse(Float.valueOf(1.0f)).floatValue();
    }
}

