/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.spi;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.etching.EtchingGearAttributes;
import iskallia.vault.gear.etching.EtchingHelper;
import iskallia.vault.skill.ability.effect.spi.core.InstantManaAbility;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.ServerScheduler;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;

public abstract class AbstractIceBoltAbility
extends InstantManaAbility {
    private float throwPower;
    private double damagePerBolt;

    public AbstractIceBoltAbility() {
        this.damagePerBolt = 0.0;
    }

    public AbstractIceBoltAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float throwPower, double damagePerBolt) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.throwPower = throwPower;
        this.damagePerBolt = damagePerBolt;
    }

    public float getThrowPower() {
        return this.throwPower;
    }

    public double getDamagePerBolt() {
        return this.damagePerBolt;
    }

    @Override
    protected void doActionPost(SkillContext context) {
        super.doActionPost(context);
        if (context.get("ice_bolt_multicast") != null) {
            return;
        }
        context.getSource().as(ServerPlayer.class).flatMap(player -> EtchingHelper.getEtchings((LivingEntity)player, EtchingGearAttributes.ICE_BOLT_MULTICAST).stream().findFirst()).ifPresent(stack -> {
            int amount = (Integer)stack.getValue();
            for (int i = 0; i < amount; ++i) {
                int delay = i + 1;
                SkillContext newCtx = context.copy();
                newCtx.set("ice_bolt_multicast", true);
                ServerScheduler.INSTANCE.schedule(delay, () -> this.onAction(newCtx));
            }
        });
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.throwPower), buffer);
        Adapters.DOUBLE.writeBits(this.damagePerBolt, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.throwPower = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.damagePerBolt = (Double)Adapters.DOUBLE.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.throwPower)).ifPresent(tag -> nbt.m_128365_("throwPower", tag));
            Adapters.DOUBLE.writeNbt(this.damagePerBolt).ifPresent(tag -> nbt.m_128365_("damagePerBolt", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.throwPower = Adapters.FLOAT.readNbt(nbt.m_128423_("throwPower")).orElse(Float.valueOf(1.0f)).floatValue();
        this.damagePerBolt = Adapters.DOUBLE.readNbt(nbt.m_128423_("damagePerBolt")).orElse(0.0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.throwPower)).ifPresent(tag -> json.add("throwPower", tag));
            Adapters.DOUBLE.writeJson(this.damagePerBolt).ifPresent(tag -> json.add("damagePerBolt", tag));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.throwPower = Adapters.FLOAT.readJson(json.get("throwPower")).orElse(Float.valueOf(1.0f)).floatValue();
        this.damagePerBolt = Adapters.DOUBLE.readJson(json.get("damagePerBolt")).orElse(0.0);
    }
}

