/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.spi;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.ability.effect.spi.core.InstantManaAbility;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.talent.type.JavelinDamageTalent;
import iskallia.vault.skill.talent.type.JavelinThrowPowerTalent;
import iskallia.vault.skill.tree.TalentTree;
import iskallia.vault.world.data.PlayerTalentsData;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public abstract class AbstractJavelinAbility
extends InstantManaAbility {
    private float percentAttackDamageDealt;
    private float throwPower;

    public AbstractJavelinAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float percentAttackDamageDealt, float throwPower) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.percentAttackDamageDealt = percentAttackDamageDealt;
        this.throwPower = throwPower;
    }

    protected AbstractJavelinAbility() {
    }

    public float getPercentAttackDamageDealt() {
        return this.percentAttackDamageDealt;
    }

    public float getThrowPower() {
        return this.throwPower;
    }

    public float getThrowPower(ServerPlayer sPlayer) {
        float additionalThrowPower = 0.0f;
        TalentTree talents = PlayerTalentsData.get(sPlayer.m_183503_()).getTalents((Player)sPlayer);
        for (JavelinThrowPowerTalent talent : talents.getAll(JavelinThrowPowerTalent.class, Skill::isUnlocked)) {
            additionalThrowPower += talent.getThrowPower();
        }
        return this.throwPower + additionalThrowPower;
    }

    public float getAttackDamage(ServerPlayer player) {
        float additionalPercentDamage = 0.0f;
        TalentTree talents = PlayerTalentsData.get(player.m_183503_()).getTalents((Player)player);
        for (JavelinDamageTalent talent : talents.getAll(JavelinDamageTalent.class, Skill::isUnlocked)) {
            additionalPercentDamage += talent.getIncreasedDamage();
        }
        return (float)player.m_21133_(Attributes.f_22281_) * (this.getPercentAttackDamageDealt() + additionalPercentDamage);
    }

    @Override
    protected void doParticles(SkillContext context) {
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.percentAttackDamageDealt), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.throwPower), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.percentAttackDamageDealt = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.throwPower = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.percentAttackDamageDealt)).ifPresent(tag -> nbt.m_128365_("percentAttackDamageDealt", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.throwPower)).ifPresent(tag -> nbt.m_128365_("throwPower", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.percentAttackDamageDealt = Adapters.FLOAT.readNbt(nbt.m_128423_("percentAttackDamageDealt")).orElse(Float.valueOf(1.0f)).floatValue();
        this.throwPower = Adapters.FLOAT.readNbt(nbt.m_128423_("throwPower")).orElse(Float.valueOf(1.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.percentAttackDamageDealt)).ifPresent(element -> json.add("percentAttackDamageDealt", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.throwPower)).ifPresent(element -> json.add("throwPower", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.percentAttackDamageDealt = Adapters.FLOAT.readJson(json.get("percentAttackDamageDealt")).orElse(Float.valueOf(1.0f)).floatValue();
        this.throwPower = Adapters.FLOAT.readJson(json.get("throwPower")).orElse(Float.valueOf(1.0f)).floatValue();
    }
}

