/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.spi;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.gear.etching.EtchingGearAttributes;
import iskallia.vault.gear.etching.EtchingHelper;
import iskallia.vault.skill.ability.effect.spi.core.InstantManaAbility;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.AABBHelper;
import iskallia.vault.util.ServerScheduler;
import iskallia.vault.util.calc.AbilityPowerHelper;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractNovaAbility
extends InstantManaAbility {
    private float radius;
    private float percentAbilityPowerDealt;
    private float knockbackStrengthMultiplier;
    private boolean autoCast;

    public AbstractNovaAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float radius, float percentAbilityPowerDealt, float knockbackStrengthMultiplier) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.radius = radius;
        this.percentAbilityPowerDealt = percentAbilityPowerDealt;
        this.knockbackStrengthMultiplier = knockbackStrengthMultiplier;
    }

    protected AbstractNovaAbility() {
        this.autoCast = false;
    }

    public float getUnmodifiedRadius() {
        return this.radius;
    }

    public float getRadius(Entity attacker) {
        float realRadius = this.getUnmodifiedRadius();
        if (attacker instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            realRadius = AreaOfEffectHelper.adjustAreaOfEffect(livingEntity, this, realRadius);
        }
        return realRadius;
    }

    public float getPercentAbilityPowerDealt() {
        return this.percentAbilityPowerDealt;
    }

    public float getKnockbackStrengthMultiplier() {
        return this.knockbackStrengthMultiplier;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    protected List<LivingEntity> getTargetEntities(Level world, LivingEntity attacker, Vec3 pos) {
        radius = this.getRadius((Entity)attacker);
        if (!(attacker instanceof ServerPlayer)) ** GOTO lbl-1000
        sPlayer = (ServerPlayer)attacker;
        if (VaultUtils.getVault(sPlayer.f_19853_).map((Function<Vault, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, isPvPVault(iskallia.vault.core.vault.Vault ), (Liskallia/vault/core/vault/Vault;)Ljava/lang/Boolean;)()).orElse(false).booleanValue()) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        allowPlayers = v0;
        return world.m_45971_(LivingEntity.class, TargetingConditions.m_148352_().m_26883_((double)radius).m_26888_((Predicate<LivingEntity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getTargetEntities$0(boolean net.minecraft.world.entity.LivingEntity ), (Lnet/minecraft/world/entity/LivingEntity;)Z)((boolean)allowPlayers)), attacker, AABBHelper.create(pos, radius));
    }

    protected float getAbilityPower(ServerPlayer player) {
        return AbilityPowerHelper.getAbilityPower((Player)player) * this.getPercentAbilityPowerDealt();
    }

    @Override
    protected void doParticles(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            float radius = this.getRadius((Entity)player);
            int particleCount = (int)Mth.m_14008_((double)(Math.pow(radius, 2.0) * 3.1415927410125732 * 50.0), (double)50.0, (double)200.0);
            ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123759_, player.m_20185_(), player.m_20186_(), player.m_20189_(), particleCount, (double)radius * 0.5, 0.5, (double)radius * 0.5, 0.0);
        });
    }

    @Override
    protected void doActionPost(SkillContext context) {
        super.doActionPost(context);
        if (this.autoCast) {
            return;
        }
        context.getSource().as(ServerPlayer.class).flatMap(player -> EtchingHelper.getEtchings((LivingEntity)player, EtchingGearAttributes.NOVA_RECAST).stream().findFirst()).ifPresent(e -> ServerScheduler.INSTANCE.schedule((Integer)e.getValue(), () -> {
            this.autoCast = true;
            this.onAction(context.copy());
            this.autoCast = false;
        }));
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.radius), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.percentAbilityPowerDealt), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.knockbackStrengthMultiplier), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.radius = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.percentAbilityPowerDealt = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.knockbackStrengthMultiplier = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.radius)).ifPresent(tag -> nbt.m_128365_("radius", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.percentAbilityPowerDealt)).ifPresent(tag -> nbt.m_128365_("percentAbilityPowerDealt", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.knockbackStrengthMultiplier)).ifPresent(tag -> nbt.m_128365_("knockbackStrengthMultiplier", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.radius = Adapters.FLOAT.readNbt(nbt.m_128423_("radius")).orElse(Float.valueOf(0.0f)).floatValue();
        this.percentAbilityPowerDealt = Adapters.FLOAT.readNbt(nbt.m_128423_("percentAbilityPowerDealt")).orElse(Float.valueOf(0.0f)).floatValue();
        this.knockbackStrengthMultiplier = Adapters.FLOAT.readNbt(nbt.m_128423_("knockbackStrengthMultiplier")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.radius)).ifPresent(element -> json.add("radius", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.percentAbilityPowerDealt)).ifPresent(element -> json.add("percentAbilityPowerDealt", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.knockbackStrengthMultiplier)).ifPresent(element -> json.add("knockbackStrengthMultiplier", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.radius = Adapters.FLOAT.readJson(json.get("radius")).orElse(Float.valueOf(0.0f)).floatValue();
        this.percentAbilityPowerDealt = Adapters.FLOAT.readJson(json.get("percentAbilityPowerDealt")).orElse(Float.valueOf(0.0f)).floatValue();
        this.knockbackStrengthMultiplier = Adapters.FLOAT.readJson(json.get("knockbackStrengthMultiplier")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    private static /* synthetic */ boolean lambda$getTargetEntities$0(boolean allowPlayers, LivingEntity entity) {
        return allowPlayers || !(entity instanceof Player);
    }
}

