/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.spi;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.ability.effect.spi.core.InstantManaAbility;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import iskallia.vault.util.calc.EffectDurationHelper;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public abstract class AbstractStonefallAbility
extends InstantManaAbility {
    private int durationTicks;
    private float knockbackMultiplier;
    private float radius;
    private float damageReduction;

    public AbstractStonefallAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, int durationTicks, float knockbackMultiplier, float radius, float damageReduction) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.durationTicks = durationTicks;
        this.knockbackMultiplier = knockbackMultiplier;
        this.radius = radius;
        this.damageReduction = damageReduction;
    }

    public AbstractStonefallAbility() {
    }

    public float getDamageReduction() {
        return this.damageReduction;
    }

    public float getUnmodifiedRadius() {
        return this.radius;
    }

    public float getRadius(Entity attacker) {
        float realRadius = this.getUnmodifiedRadius();
        if (attacker instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            realRadius = AreaOfEffectHelper.adjustAreaOfEffect(livingEntity, this, realRadius);
        }
        return realRadius;
    }

    public int getDurationTicksUnmodified() {
        return this.durationTicks;
    }

    public int getDurationTicks(LivingEntity entity) {
        int duration = this.getDurationTicksUnmodified();
        return EffectDurationHelper.adjustEffectDurationFloor(entity, duration);
    }

    public float getKnockbackMultiplier() {
        return this.knockbackMultiplier;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.durationTicks, buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.knockbackMultiplier), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.radius), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.damageReduction), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.durationTicks = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        this.knockbackMultiplier = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.radius = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.damageReduction = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.durationTicks).ifPresent(tag -> nbt.m_128365_("durationTicks", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.knockbackMultiplier)).ifPresent(tag -> nbt.m_128365_("knockbackMultiplier", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.radius)).ifPresent(tag -> nbt.m_128365_("radius", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.damageReduction)).ifPresent(tag -> nbt.m_128365_("damageReduction", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.durationTicks = Adapters.INT.readNbt(nbt.m_128423_("durationTicks")).orElse(0);
        this.knockbackMultiplier = Adapters.FLOAT.readNbt(nbt.m_128423_("knockbackMultiplier")).orElse(Float.valueOf(0.0f)).floatValue();
        this.radius = Adapters.FLOAT.readNbt(nbt.m_128423_("radius")).orElse(Float.valueOf(0.0f)).floatValue();
        this.damageReduction = Adapters.FLOAT.readNbt(nbt.m_128423_("damageReduction")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.durationTicks).ifPresent(element -> json.add("durationTicks", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.knockbackMultiplier)).ifPresent(element -> json.add("knockbackMultiplier", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.radius)).ifPresent(element -> json.add("radius", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.damageReduction)).ifPresent(element -> json.add("damageReduction", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.durationTicks = Adapters.INT.readJson(json.get("durationTicks")).orElse(0);
        this.knockbackMultiplier = Adapters.FLOAT.readJson(json.get("knockbackMultiplier")).orElse(Float.valueOf(0.0f)).floatValue();
        this.radius = Adapters.FLOAT.readJson(json.get("radius")).orElse(Float.valueOf(0.0f)).floatValue();
        this.damageReduction = Adapters.FLOAT.readJson(json.get("damageReduction")).orElse(Float.valueOf(0.0f)).floatValue();
    }
}

