/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.spi;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.skill.ability.effect.spi.core.InstantManaAbility;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.calc.AbilityPowerHelper;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import iskallia.vault.util.calc.EffectDurationHelper;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;

public abstract class AbstractStormArrowAbility
extends InstantManaAbility {
    private float percentAbilityPowerDealtMin;
    private float percentAbilityPowerDealtMax;
    private float radius;
    private int cloudDuration;
    private int intervalTicks;

    public AbstractStormArrowAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float percentAbilityPowerDealtMin, float percentAbilityPowerDealtMax, float radius, int cloudDuration, int intervalTicks) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.percentAbilityPowerDealtMin = percentAbilityPowerDealtMin;
        this.percentAbilityPowerDealtMax = percentAbilityPowerDealtMax;
        this.radius = radius;
        this.cloudDuration = cloudDuration;
        this.intervalTicks = intervalTicks;
    }

    protected AbstractStormArrowAbility() {
    }

    public float getPercentAbilityPowerDealt(RandomSource source) {
        return source.nextFloat(this.percentAbilityPowerDealtMin, this.percentAbilityPowerDealtMax);
    }

    public float getAbilityPowerPercentMin() {
        return this.percentAbilityPowerDealtMin;
    }

    public float getAbilityPowerPercentMax() {
        return this.percentAbilityPowerDealtMax;
    }

    public float getUnmodifiedRadius() {
        return this.radius;
    }

    public float getRadius(Entity attacker) {
        float realRadius = this.getUnmodifiedRadius();
        if (attacker instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            realRadius = AreaOfEffectHelper.adjustAreaOfEffect(livingEntity, this, realRadius);
        }
        return realRadius;
    }

    public int getUnmodifiedDuration() {
        return this.cloudDuration;
    }

    public int getDuration(LivingEntity entity) {
        int duration = this.getUnmodifiedDuration();
        return EffectDurationHelper.adjustEffectDurationFloor(entity, duration);
    }

    public int getIntervalTicks() {
        return this.intervalTicks;
    }

    public float getAbilityPower(ServerPlayer player) {
        return AbilityPowerHelper.getAbilityPower((Player)player) * this.getPercentAbilityPowerDealt(JavaRandom.ofNanoTime());
    }

    @Override
    protected void doParticles(SkillContext context) {
    }

    public Vec2 getShootRotation(ServerPlayer player) {
        return new Vec2(player.m_146909_(), player.m_146908_());
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.percentAbilityPowerDealtMin), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.percentAbilityPowerDealtMax), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.radius), buffer);
        Adapters.INT.writeBits(this.cloudDuration, buffer);
        Adapters.INT.writeBits(this.intervalTicks, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.percentAbilityPowerDealtMin = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.percentAbilityPowerDealtMax = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.radius = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.cloudDuration = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
        this.intervalTicks = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.percentAbilityPowerDealtMin)).ifPresent(tag -> nbt.m_128365_("percentAbilityPowerDealtMin", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.percentAbilityPowerDealtMax)).ifPresent(tag -> nbt.m_128365_("percentAbilityPowerDealtMax", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.radius)).ifPresent(tag -> nbt.m_128365_("radius", tag));
            Adapters.INT.writeNbt(this.cloudDuration).ifPresent(tag -> nbt.m_128365_("cloudDuration", tag));
            Adapters.INT.writeNbt(this.intervalTicks).ifPresent(tag -> nbt.m_128365_("intervalTicks", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.percentAbilityPowerDealtMin = Adapters.FLOAT.readNbt(nbt.m_128423_("percentAbilityPowerDealtMin")).orElse(Float.valueOf(1.0f)).floatValue();
        this.percentAbilityPowerDealtMax = Adapters.FLOAT.readNbt(nbt.m_128423_("percentAbilityPowerDealtMax")).orElse(Float.valueOf(1.0f)).floatValue();
        this.radius = Adapters.FLOAT.readNbt(nbt.m_128423_("radius")).orElse(Float.valueOf(1.0f)).floatValue();
        this.cloudDuration = Adapters.INT.readNbt(nbt.m_128423_("cloudDuration")).orElse(200);
        this.intervalTicks = Adapters.INT.readNbt(nbt.m_128423_("intervalTicks")).orElse(10);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.percentAbilityPowerDealtMin)).ifPresent(element -> json.add("percentAbilityPowerDealtMin", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.percentAbilityPowerDealtMax)).ifPresent(element -> json.add("percentAbilityPowerDealtMax", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.radius)).ifPresent(element -> json.add("radius", element));
            Adapters.INT.writeJson(this.cloudDuration).ifPresent(element -> json.add("cloudDuration", element));
            Adapters.INT.writeJson(this.intervalTicks).ifPresent(element -> json.add("intervalTicks", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.percentAbilityPowerDealtMin = Adapters.FLOAT.readJson(json.get("percentAbilityPowerDealtMin")).orElse(Float.valueOf(1.0f)).floatValue();
        this.percentAbilityPowerDealtMax = Adapters.FLOAT.readJson(json.get("percentAbilityPowerDealtMax")).orElse(Float.valueOf(1.0f)).floatValue();
        this.radius = Adapters.FLOAT.readJson(json.get("radius")).orElse(Float.valueOf(1.0f)).floatValue();
        this.cloudDuration = Adapters.INT.readJson(json.get("cloudDuration")).orElse(200);
        this.intervalTicks = Adapters.INT.readJson(json.get("intervalTicks")).orElse(10);
    }
}

