/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.spi;

import com.google.gson.JsonObject;
import iskallia.vault.block.entity.TotemTileEntity;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.world.storage.IZonedWorld;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.InstantManaAbility;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.MathUtilities;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import iskallia.vault.util.calc.EffectDurationHelper;
import iskallia.vault.util.calc.TotemDurationHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTotemAbility<T extends TotemTileEntity>
extends InstantManaAbility {
    private int totemDurationTicks;
    private float totemEffectRadius;

    public AbstractTotemAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, int totemDurationTicks, float totemEffectRadius) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.totemDurationTicks = totemDurationTicks;
        this.totemEffectRadius = totemEffectRadius;
    }

    protected AbstractTotemAbility() {
    }

    public int getUnmodifiedTotemDurationTicks() {
        return this.totemDurationTicks;
    }

    public float getUnmodifiedTotemEffectRadius() {
        return this.totemEffectRadius;
    }

    public float getTotemEffectRadius(Player player) {
        float realRadius = this.getUnmodifiedTotemEffectRadius();
        realRadius = AreaOfEffectHelper.adjustAreaOfEffect((LivingEntity)player, this, realRadius);
        return realRadius;
    }

    public int getTotemDurationTicks(LivingEntity entity) {
        int duration = this.getUnmodifiedTotemDurationTicks();
        return EffectDurationHelper.adjustEffectDurationFloor(entity, duration);
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            int cooldownDelayTicks = TotemDurationHelper.adjustTotemDurationTicks(player, this.getTotemDurationTicks((LivingEntity)player));
            return this.placeTotem((ServerPlayer)player) ? Ability.ActionResult.successCooldownDelayed(cooldownDelayTicks) : Ability.ActionResult.fail();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    protected void doSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            player.f_19853_.m_6263_((Player)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.TOTEM, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_6330_(ModSounds.TOTEM, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.f_19853_.m_6263_((Player)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11736_, SoundSource.PLAYERS, 0.5f, 2.0f);
            player.m_6330_(SoundEvents.f_11736_, SoundSource.PLAYERS, 0.5f, 2.0f);
        });
    }

    @Nonnull
    protected abstract BlockState getTotemForPlacement();

    protected abstract Class<T> getTotemTileEntityClass();

    protected boolean placeTotem(ServerPlayer player) {
        ServerLevel level = player.m_183503_();
        BlockPos spawnPosition = this.getSpawnPosition(player);
        if (spawnPosition == null) {
            return false;
        }
        IZonedWorld.runWithBypass(level, true, () -> level.m_46597_(spawnPosition, this.getTotemForPlacement()));
        BlockEntity blockEntity = level.m_7702_(spawnPosition);
        if (this.getTotemTileEntityClass().isInstance(blockEntity)) {
            this.initializeTotem((TotemTileEntity)((Object)this.getTotemTileEntityClass().cast(blockEntity)), player);
        }
        return true;
    }

    protected abstract void initializeTotem(T var1, ServerPlayer var2);

    @Nullable
    private BlockPos getSpawnPosition(ServerPlayer player) {
        BlockPos playerBlockPos = player.m_20097_().m_7494_();
        ArrayList<BlockPos> candidateList = new ArrayList<BlockPos>();
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                for (int y = -2; y <= 2; ++y) {
                    candidateList.add(playerBlockPos.m_142082_(x, y, z));
                }
            }
        }
        Direction direction = player.m_6350_();
        BlockPos preferredBlockPos = playerBlockPos.m_142082_(direction.m_122429_(), direction.m_122430_(), direction.m_122431_());
        List<BlockPos> spawnPositionList = candidateList.stream().filter(blockPos -> this.canSpawnAt(player.f_19853_, (BlockPos)blockPos)).sorted(Comparator.comparingDouble(o -> MathUtilities.getDistanceSqr(o, preferredBlockPos))).toList();
        if (!spawnPositionList.isEmpty()) {
            for (BlockPos blockPos2 : spawnPositionList) {
                BlockPos blockPosBelow = blockPos2.m_7495_();
                BlockState blockStateBelow = player.f_19853_.m_8055_(blockPosBelow);
                if (!blockStateBelow.m_60783_((BlockGetter)player.f_19853_, blockPosBelow, Direction.UP)) continue;
                return blockPos2;
            }
            return spawnPositionList.get(0);
        }
        return null;
    }

    private boolean canSpawnAt(Level level, BlockPos blockPos) {
        BlockState blockState = level.m_8055_(blockPos);
        return blockState.m_60795_() || blockState.m_60767_().m_76336_();
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.totemDurationTicks, buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.totemEffectRadius), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.totemDurationTicks = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        this.totemEffectRadius = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.totemDurationTicks).ifPresent(tag -> nbt.m_128365_("totemDurationTicks", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.totemEffectRadius)).ifPresent(tag -> nbt.m_128365_("totemEffectRadius", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.totemDurationTicks = Adapters.INT.readNbt(nbt.m_128423_("totemDurationTicks")).orElse(0);
        this.totemEffectRadius = Adapters.FLOAT.readNbt(nbt.m_128423_("totemEffectRadius")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.totemDurationTicks).ifPresent(element -> json.add("totemDurationTicks", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.totemEffectRadius)).ifPresent(element -> json.add("totemEffectRadius", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.totemDurationTicks = Adapters.INT.readJson(json.get("totemDurationTicks")).orElse(0);
        this.totemEffectRadius = Adapters.FLOAT.readJson(json.get("totemEffectRadius")).orElse(Float.valueOf(0.0f)).floatValue();
    }
}

