/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.spi;

import com.google.gson.JsonObject;
import iskallia.vault.block.entity.base.HunterHiddenTileEntity;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.world.data.tile.TilePredicate;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.network.message.ClientboundHunterPositionsMessage;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.InstantManaAbility;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.tags.ModBlockTags;
import iskallia.vault.util.ServerScheduler;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import iskallia.vault.util.calc.EffectDurationHelper;
import iskallia.vault.world.data.ServerVaults;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.NetworkDirection;

public class HunterAbility
extends InstantManaAbility {
    private static final Map<Block, Target> BLOCK_TYPES = new HashMap<Block, Target>(){
        {
            this.put(ModBlocks.WOODEN_CHEST, Target.WOODEN);
            this.put(ModBlocks.GILDED_CHEST, Target.GILDED);
            this.put(ModBlocks.GILDED_STRONGBOX, Target.GILDED);
            this.put(ModBlocks.ORNATE_CHEST, Target.ORNATE);
            this.put(ModBlocks.ORNATE_STRONGBOX, Target.ORNATE);
            this.put(ModBlocks.LIVING_CHEST, Target.LIVING);
            this.put(ModBlocks.LIVING_STRONGBOX, Target.LIVING);
            this.put(ModBlocks.COIN_PILE, Target.COINS);
            this.put(ModBlocks.HARDENED_CHEST, Target.HARDENED);
            this.put(ModBlocks.ENIGMA_CHEST, Target.ENIGMA);
            this.put(ModBlocks.FLESH_CHEST, Target.FLESH);
            this.put(ModBlocks.GOD_ALTAR, Target.GOD_ALTARS);
        }
    };
    private double searchRadius;
    private int color;
    private int durationTicks;
    private List<TilePredicate> filters;
    private static ArrayAdapter<TilePredicate> KEYS = Adapters.ofArray(TilePredicate[]::new, Adapters.TILE_PREDICATE);

    public HunterAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, double searchRadius, int color, int durationTicks, List<TilePredicate> filters) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.searchRadius = searchRadius;
        this.color = color;
        this.durationTicks = durationTicks;
        this.filters = filters;
    }

    public HunterAbility() {
    }

    public static Optional<Target> getHighlightType(BlockEntity blockEntity) {
        BlockState state = blockEntity.m_58900_();
        if (state.m_204336_(ModBlockTags.OBJECTIVE_BLOCKS)) {
            return Optional.of(Target.OBJECTIVES);
        }
        Block block = state.m_60734_();
        for (Map.Entry<Block, Target> entry : BLOCK_TYPES.entrySet()) {
            if (entry.getKey() != block) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    public double getUnmodifiedSearchRadius() {
        return this.searchRadius;
    }

    public double getRadius(Entity attacker) {
        double realRadius = this.getUnmodifiedSearchRadius();
        if (attacker instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            realRadius = AreaOfEffectHelper.adjustAreaOfEffect(livingEntity, this, (float)realRadius);
        }
        return realRadius;
    }

    public int getColor() {
        return this.color;
    }

    public int getUnmodifiedDurationTicks() {
        return this.durationTicks;
    }

    public int getDurationTicks(LivingEntity entity) {
        int duration = this.getUnmodifiedDurationTicks();
        return EffectDurationHelper.adjustEffectDurationFloor(entity, duration);
    }

    @Override
    protected boolean canDoAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> super.canDoAction(context) && ServerVaults.get(player.f_19853_).isPresent()).orElse(false);
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            Level world = player.m_20193_();
            if (!(world instanceof ServerLevel)) {
                return Ability.ActionResult.fail();
            }
            ServerLevel serverWorld = (ServerLevel)world;
            int duration = this.getDurationTicks((LivingEntity)player);
            for (int delay = 0; delay < duration / 5; ++delay) {
                ServerScheduler.INSTANCE.schedule(delay * 5, () -> {
                    List<HighlightPosition> positions = HunterAbility.selectPositions(serverWorld, (Player)player, this.getRadius((Entity)player));
                    ModNetwork.CHANNEL.sendTo((Object)new ClientboundHunterPositionsMessage(positions), player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
                });
            }
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    protected void doParticles(SkillContext context) {
    }

    @Override
    protected void doSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> player.f_19853_.m_6263_(null, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, ModSounds.HUNTER_SFX, SoundSource.PLAYERS, 1.0f, 1.0f));
    }

    public static List<HighlightPosition> selectPositions(ServerLevel world, Player player, double radius) {
        return HunterAbility.selectPositions(world, player.m_142538_(), radius);
    }

    public static List<HighlightPosition> selectPositions(ServerLevel world, BlockPos offset, double radius) {
        return HunterAbility.selectPositions(world, offset, radius, (BlockEntity tile) -> HunterAbility.getHighlightType(tile).map(target -> new HighlightPosition(tile.m_58899_(), (Target)((Object)((Object)target)), 0xFFFFFF)));
    }

    public static List<HighlightPosition> selectPositions(ServerLevel world, Player player, double radius, Function<BlockEntity, Optional<HighlightPosition>> getHighlightPosition) {
        return HunterAbility.selectPositions(world, player.m_142538_(), radius, getHighlightPosition);
    }

    public static List<HighlightPosition> selectPositions(ServerLevel world, BlockPos offset, double radius, Function<BlockEntity, Optional<HighlightPosition>> getHighlightPosition) {
        ArrayList<HighlightPosition> result = new ArrayList<HighlightPosition>();
        HunterAbility.forEachTile((Level)world, offset, radius, tile -> ((Optional)getHighlightPosition.apply((BlockEntity)tile)).ifPresent(result::add));
        return result;
    }

    private static void forEachTile(Level world, BlockPos offset, double radius, Consumer<BlockEntity> consumer) {
        double radiusSq = radius * radius;
        int iRadius = Mth.m_14165_((double)radius);
        Vec3i radVec = new Vec3i(iRadius, iRadius, iRadius);
        ChunkPos posMin = new ChunkPos(offset.m_141950_(radVec));
        ChunkPos posMax = new ChunkPos(offset.m_141952_(radVec));
        for (int xx = posMin.f_45578_; xx <= posMax.f_45578_; ++xx) {
            for (int zz = posMin.f_45579_; zz <= posMax.f_45579_; ++zz) {
                LevelChunk ch = world.m_7726_().m_7131_(xx, zz);
                if (ch == null) continue;
                ch.m_62954_().forEach((pos, tile) -> {
                    HunterHiddenTileEntity hidden;
                    if (!(tile == null || !(pos.m_123331_((Vec3i)offset) <= radiusSq) || tile instanceof HunterHiddenTileEntity && (hidden = (HunterHiddenTileEntity)tile).isHidden())) {
                        consumer.accept((BlockEntity)tile);
                    }
                });
            }
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.DOUBLE.writeBits(this.searchRadius, buffer);
        Adapters.INT.writeBits(this.color, buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.durationTicks, buffer);
        KEYS.writeBits((TilePredicate)((TilePredicate[])this.filters.toArray(TilePredicate[]::new)), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.searchRadius = (Double)Adapters.DOUBLE.readBits(buffer).orElseThrow();
        this.color = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
        this.durationTicks = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        this.filters = Arrays.stream((TilePredicate[])KEYS.readBits(buffer).orElseThrow()).toList();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.DOUBLE.writeNbt(this.searchRadius).ifPresent(tag -> nbt.m_128365_("searchRadius", tag));
            Adapters.INT.writeNbt(this.color).ifPresent(tag -> nbt.m_128365_("color", tag));
            Adapters.INT.writeNbt(this.durationTicks).ifPresent(tag -> nbt.m_128365_("durationTicks", tag));
            KEYS.writeNbt((TilePredicate)((TilePredicate[])this.filters.toArray(TilePredicate[]::new))).ifPresent(tag -> nbt.m_128365_("filters", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.searchRadius = Adapters.DOUBLE.readNbt(nbt.m_128423_("searchRadius")).orElse(0.0);
        this.color = Adapters.INT.readNbt(nbt.m_128423_("color")).orElse(0);
        this.durationTicks = Adapters.INT.readNbt(nbt.m_128423_("durationTicks")).orElse(0);
        this.filters = Arrays.stream(KEYS.readNbt(nbt.m_128423_("filters")).orElse(new TilePredicate[0])).toList();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.DOUBLE.writeJson(this.searchRadius).ifPresent(element -> json.add("searchRadius", element));
            Adapters.INT.writeJson(this.color).ifPresent(element -> json.add("color", element));
            Adapters.INT.writeJson(this.durationTicks).ifPresent(element -> json.add("durationTicks", element));
            KEYS.writeJson((TilePredicate)((TilePredicate[])this.filters.toArray(TilePredicate[]::new))).ifPresent(element -> json.add("filters", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.searchRadius = Adapters.DOUBLE.readJson(json.get("searchRadius")).orElse(0.0);
        this.color = Adapters.INT.readJson(json.get("color")).orElse(0);
        this.durationTicks = Adapters.INT.readJson(json.get("durationTicks")).orElse(0);
        this.filters = Arrays.stream(KEYS.readJson(json.get("filters")).orElse(new TilePredicate[0])).toList();
    }

    public static enum Target {
        WOODEN,
        GILDED,
        ORNATE,
        LIVING,
        COINS,
        HARDENED,
        ENIGMA,
        FLESH,
        OBJECTIVES,
        GOD_ALTARS,
        DUNGEONS,
        VENDOORS,
        TREASURE_DOORS,
        PYLONS;


        public Target next() {
            Target[] values = Target.values();
            return values[(this.ordinal() + 1) % values.length];
        }

        public boolean is(String target) {
            return this.name().equalsIgnoreCase(target);
        }

        public static Target of(String target) {
            if (target == null || target.isEmpty()) {
                return null;
            }
            target = target.toUpperCase(Locale.ROOT);
            try {
                return Target.valueOf(target);
            }
            catch (IllegalArgumentException ignored) {
                return null;
            }
        }
    }

    public record HighlightPosition(BlockPos blockPos, @Nullable Target target, int color) {
    }
}

