/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.spi.core;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.SkillContext;
import net.minecraft.world.entity.Entity;

public abstract class InstantAbility
extends Ability {
    public InstantAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks);
    }

    protected InstantAbility() {
    }

    @Override
    public boolean onKeyUp(SkillContext context) {
        if (!super.onKeyUp(context)) {
            return false;
        }
        Ability.ActionResult result = this.onAction(context);
        if (result.startCooldown()) {
            this.putOnCooldown(result.getCooldownDelayTicks(), context);
        }
        return true;
    }

    public Ability.ActionResult onAction(SkillContext context) {
        Ability.ActionResult result;
        if (this.canDoAction(context) && (result = this.doAction(context)).isSuccess()) {
            this.doActionPost(context);
            this.doParticles(context);
            this.doSound(context);
            return result;
        }
        return Ability.ActionResult.fail();
    }

    protected boolean canDoAction(SkillContext context) {
        return true;
    }

    protected Ability.ActionResult doAction(SkillContext context) {
        return Ability.ActionResult.fail();
    }

    protected void doActionPost(SkillContext context) {
        context.getSource().as(Entity.class).ifPresent(entity -> CommonEvents.ABILITY_CAST.invoke((Entity)entity, this, context));
    }

    protected void doParticles(SkillContext context) {
    }

    protected void doSound(SkillContext context) {
    }
}

