/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.spi.core;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.mana.ManaAction;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.IPerSecondManaAbility;
import iskallia.vault.skill.ability.effect.spi.core.ToggleAbility;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.calc.ManaCostHelper;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;

public abstract class ToggleManaAbility
extends ToggleAbility
implements IPerSecondManaAbility {
    private float manaCostPerSecond;

    public ToggleManaAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCostPerSecond) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks);
        this.manaCostPerSecond = manaCostPerSecond;
    }

    protected ToggleManaAbility() {
    }

    @Override
    public float getManaCostPerSecond() {
        return this.manaCostPerSecond;
    }

    @Override
    protected boolean canToggle(SkillContext context) {
        return context.getSource().getMana().map(mana -> {
            if (!this.isActive()) {
                return true;
            }
            float cost = this.getManaCostPerSecond();
            if (mana instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)mana;
                if (player.m_7500_()) {
                    return true;
                }
                cost = ManaCostHelper.adjustManaCost(player, this, cost);
            }
            return mana.getMana() >= cost;
        }).orElse(false);
    }

    @Override
    public Ability.TickResult doActiveTick(SkillContext context) {
        return context.getSource().getMana().map(mana -> {
            float cost = this.getManaCostPerSecond() / 20.0f;
            if (mana instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)mana;
                if (player.m_7500_() || player.m_5833_()) {
                    return Ability.TickResult.PASS;
                }
                cost = ManaCostHelper.adjustManaCost(player, this, cost);
            }
            if (mana.decreaseMana(ManaAction.PLAYER_ACTION, cost) <= 0.0f) {
                this.doManaDepleted(context);
                this.setActive(false);
                return Ability.TickResult.COOLDOWN;
            }
            return Ability.TickResult.PASS;
        }).orElse(Ability.TickResult.PASS);
    }

    protected void doManaDepleted(SkillContext context) {
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.manaCostPerSecond), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.manaCostPerSecond = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.manaCostPerSecond)).ifPresent(tag -> nbt.m_128365_("manaCostPerSecond", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.manaCostPerSecond = Adapters.FLOAT.readNbt(nbt.m_128423_("manaCostPerSecond")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.manaCostPerSecond)).ifPresent(element -> json.add("manaCostPerSecond", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.manaCostPerSecond = Adapters.FLOAT.readJson(json.get("manaCostPerSecond")).orElse(Float.valueOf(0.0f)).floatValue();
    }
}

