/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.base;

import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.skill.source.SkillSource;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SkillContext {
    private int level;
    private int learnPoints;
    private int additionalLearnPoints = 0;
    private SkillSource source;
    private final transient Map<String, Object> flags = new HashMap<String, Object>();

    public SkillContext(int level, int learnPoints, SkillSource source) {
        this.level = level;
        this.learnPoints = learnPoints;
        this.source = source;
    }

    public SkillContext(int level, int learnPoints, int additionalLearnPoints, SkillSource source) {
        this.level = level;
        this.learnPoints = learnPoints;
        this.additionalLearnPoints = additionalLearnPoints;
        this.source = source;
    }

    public static SkillContext empty() {
        return new SkillContext(0, 0, SkillSource.empty());
    }

    public static SkillContext of(ServerPlayer player) {
        PlayerVaultStats stats = PlayerVaultStatsData.get((ServerLevel)player.f_19853_).getVaultStats((Player)player);
        return new SkillContext(stats.getVaultLevel(), stats.getUnspentSkillPoints(), SkillSource.of((Entity)player));
    }

    public static SkillContext of(ServerPlayer player, SkillSource source) {
        PlayerVaultStats stats = PlayerVaultStatsData.get((ServerLevel)player.f_19853_).getVaultStats((Player)player);
        return new SkillContext(stats.getVaultLevel(), stats.getUnspentSkillPoints(), source);
    }

    public static SkillContext ofExpertise(ServerPlayer player) {
        PlayerVaultStats stats = PlayerVaultStatsData.get((ServerLevel)player.f_19853_).getVaultStats((Player)player);
        return new SkillContext(stats.getVaultLevel(), stats.getUnspentExpertisePoints(), SkillSource.of((Entity)player));
    }

    public static SkillContext ofPrestige(ServerPlayer player) {
        PlayerVaultStats stats = PlayerVaultStatsData.get((ServerLevel)player.f_19853_).getVaultStats((Player)player);
        return new SkillContext(stats.getVaultLevel(), stats.getUnspentPrestigePoints(), stats.getUnspentKnowledgePoints(), SkillSource.of((Entity)player));
    }

    public void set(String key, Object value) {
        this.flags.put(key, value);
    }

    public Object get(String key) {
        return this.flags.get(key);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static SkillContext ofClient() {
        return new SkillContext(VaultBarOverlay.vaultLevel, VaultBarOverlay.unspentSkillPoints, SkillSource.of((Entity)Minecraft.m_91087_().f_91074_));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static SkillContext ofExpertiseClient() {
        return new SkillContext(VaultBarOverlay.vaultLevel, VaultBarOverlay.unspentExpertisePoints, SkillSource.of((Entity)Minecraft.m_91087_().f_91074_));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static SkillContext ofPrestigeClient() {
        return new SkillContext(VaultBarOverlay.vaultLevel, VaultBarOverlay.unspentPrestigePoints, VaultBarOverlay.unspentKnowledgePoints, SkillSource.of((Entity)Minecraft.m_91087_().f_91074_));
    }

    public SkillContext copy() {
        SkillContext ctx = new SkillContext(this.level, this.learnPoints, this.additionalLearnPoints, this.source.copy());
        ctx.flags.putAll(this.flags);
        return ctx;
    }

    public int getLevel() {
        return this.level;
    }

    public int getLearnPoints() {
        return this.learnPoints;
    }

    public SkillSource getSource() {
        return this.source;
    }

    public void setLearnPoints(int learnPoints) {
        this.learnPoints = learnPoints;
    }

    public int getAdditionalLearnPoints() {
        return this.additionalLearnPoints;
    }

    public void setAdditionalLearnPoints(int additionalLearnPoints) {
        this.additionalLearnPoints = additionalLearnPoints;
    }
}

