/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.base;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.ability.effect.spi.core.Cooldown;
import iskallia.vault.skill.ability.effect.spi.core.CooldownSkill;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.TieredSkill;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;

public class SpecializedSkill
extends LearnableSkill
implements CooldownSkill {
    private List<LearnableSkill> specializations;
    private int index;
    private static final ArrayAdapter<Skill> SPECIALIZATIONS = Adapters.ofArray(Skill[]::new, Adapters.SKILL);

    public SpecializedSkill(int unlockLevel, int learnPointCost, int regretPointCost, Stream<LearnableSkill> children) {
        super(unlockLevel, learnPointCost, regretPointCost);
        this.specializations = children.toList();
        this.specializations.forEach(specialization -> specialization.setParent(this));
    }

    public SpecializedSkill() {
    }

    public Stream<Skill> getChildren() {
        return this.specializations.stream().map(skill -> skill);
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public int getUnlockLevel() {
        return this.specializations.get(this.index).getUnlockLevel();
    }

    @Override
    public int getLearnPointCost() {
        return this.specializations.get(this.index).getLearnPointCost();
    }

    @Override
    public int getRegretCost() {
        return this.specializations.get(this.index).getRegretCost();
    }

    @Override
    public int getSpentLearnPoints() {
        return this.specializations.get(this.index).getSpentLearnPoints();
    }

    @Override
    public boolean isUnlocked() {
        return this.specializations.get(this.index).isUnlocked();
    }

    @Override
    public boolean canLearn(SkillContext context) {
        return this.specializations.get(this.index).canLearn(context);
    }

    @Override
    public void learn(SkillContext context) {
        this.specializations.get(this.index).learn(context);
    }

    @Override
    public boolean canRegret(SkillContext context) {
        return this.specializations.get(this.index).canRegret(context);
    }

    @Override
    public void regret(SkillContext context) {
        this.specializations.get(this.index).regret(context);
    }

    public LearnableSkill getSpecialization() {
        return this.specializations.get(this.index);
    }

    public LearnableSkill getSpecialization(int index) {
        return this.specializations.get(0);
    }

    public List<LearnableSkill> getSpecializations() {
        return this.specializations;
    }

    public void resetSpecialization(SkillContext context) {
        this.specialize(0, context);
    }

    public void specialize(int index, SkillContext context) {
        if (this.index != index) {
            LearnableSkill current = this.specializations.get(this.index);
            if (current instanceof TieredSkill) {
                int i;
                TieredSkill tiered = (TieredSkill)current;
                int tier = tiered.getUnmodifiedTier();
                for (i = 0; i < tier; ++i) {
                    current.regret(context);
                }
                for (i = 0; i < tier; ++i) {
                    if (!this.specializations.get(index).canLearn(context)) continue;
                    this.specializations.get(index).learn(context);
                }
            } else {
                int tier = 0;
                while (current.isUnlocked()) {
                    current.regret(context);
                    ++tier;
                }
                for (int i = 0; i < tier; ++i) {
                    if (!this.specializations.get(index).canLearn(context)) continue;
                    this.specializations.get(index).learn(context);
                }
            }
        }
        this.index = index;
    }

    public void specialize(String id, SkillContext context) {
        for (int i = 0; i < this.specializations.size(); ++i) {
            LearnableSkill specialization = this.specializations.get(i);
            if (!specialization.getId().equals(id)) continue;
            this.specialize(i, context);
            break;
        }
    }

    public int indexOf(String id) {
        List<LearnableSkill> learnableSkills = this.specializations;
        for (int i = 0; i < learnableSkills.size(); ++i) {
            LearnableSkill specialization = learnableSkills.get(i);
            if (!specialization.getId().equals(id)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Optional<Skill> getForId(String id) {
        return super.getForId(id).or(() -> {
            for (Skill skill : this.specializations) {
                Skill skill2 = skill.getForId(id).orElse(null);
                if (skill2 == null) continue;
                return Optional.of(skill2);
            }
            return Optional.empty();
        });
    }

    @Override
    public <T> void iterate(Class<T> type, Consumer<T> action) {
        super.iterate(type, action);
        for (LearnableSkill specialization : this.specializations) {
            specialization.iterate(type, action);
        }
    }

    @Override
    public Skill mergeFrom(Skill other, SkillContext context) {
        int spentPoints = this.getSpentLearnPoints();
        if (!(other instanceof SpecializedSkill)) {
            context.setLearnPoints(context.getLearnPoints() + spentPoints);
            return other;
        }
        SpecializedSkill specialized = (SpecializedSkill)other;
        LinkedHashMap<String, Skill> idToSkill = new LinkedHashMap<String, Skill>();
        LinkedHashMap<String, Integer> idToIndex = new LinkedHashMap<String, Integer>();
        for (int index = 0; index < specialized.specializations.size(); ++index) {
            Skill skill = specialized.specializations.get(index);
            idToSkill.put(skill.getId(), skill);
            idToIndex.put(skill.getId(), index);
        }
        for (Skill skill : this.specializations) {
            Skill merged = skill.getId() == null || !idToSkill.containsKey(skill.getId()) ? skill.mergeFrom(null, context) : skill.mergeFrom((Skill)idToSkill.get(skill.getId()), context);
            if (!idToIndex.containsKey(skill.getId()) || !(merged instanceof LearnableSkill)) continue;
            LearnableSkill learnable = (LearnableSkill)merged;
            specialized.specializations.set((Integer)idToIndex.get(skill.getId()), learnable);
        }
        String selected = this.specializations.get(this.index).getId();
        specialized.index = selected != null && idToIndex.containsKey(selected) ? (Integer)idToIndex.get(selected) : 0;
        return other;
    }

    @Override
    public Optional<Cooldown> getCooldown() {
        Cooldown max = null;
        for (LearnableSkill child : this.specializations) {
            Cooldown cooldown;
            if (!(child instanceof CooldownSkill) || (cooldown = (Cooldown)((CooldownSkill)((Object)child)).getCooldown().orElse(null)) == null || max != null && !cooldown.isLargerThan(max)) continue;
            max = cooldown;
        }
        return Optional.ofNullable(max);
    }

    @Override
    public void putOnCooldown(int cooldownDelayTicks, SkillContext context) {
        LearnableSkill child = this.getSpecialization();
        if (child instanceof CooldownSkill) {
            ((CooldownSkill)((Object)child)).putOnCooldown(cooldownDelayTicks, context);
        }
    }

    @Override
    public <T extends Skill> T copy() {
        SpecializedSkill copy = new SpecializedSkill(this.unlockLevel, this.learnPointCost, this.regretCost, this.specializations.stream().map(Skill::copy));
        copy.parent = this.parent;
        copy.id = this.id;
        copy.name = this.name;
        copy.present = this.present;
        copy.learnPointCost = this.learnPointCost;
        copy.regretCost = this.regretCost;
        copy.unlockLevel = this.unlockLevel;
        copy.index = this.index;
        return (T)copy;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        SPECIALIZATIONS.writeBits((Skill)((Skill[])this.specializations.toArray(Skill[]::new)), buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.index, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.specializations = Arrays.stream((Skill[])SPECIALIZATIONS.readBits(buffer).orElseThrow()).map(skill -> (LearnableSkill)skill).collect(Collectors.toList());
        this.index = Adapters.INT_SEGMENTED_3.readBits(buffer).orElse(0);
        this.specializations.forEach(specialization -> specialization.setParent(this));
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            SPECIALIZATIONS.writeNbt((Skill)((Skill[])this.specializations.toArray(Skill[]::new))).ifPresent(tag -> nbt.m_128365_("specializations", tag));
            Adapters.INT_SEGMENTED_3.writeNbt(this.index).ifPresent(tag -> nbt.m_128365_("index", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.specializations = Arrays.stream((Skill[])SPECIALIZATIONS.readNbt(nbt.m_128423_("specializations")).orElseThrow()).map(skill -> (LearnableSkill)skill).collect(Collectors.toList());
        this.index = Adapters.INT_SEGMENTED_3.readNbt(nbt.m_128423_("index")).orElse(0);
        this.specializations.forEach(specialization -> specialization.setParent(this));
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            SPECIALIZATIONS.writeJson((Skill)((Skill[])this.specializations.toArray(Skill[]::new))).ifPresent(element -> json.add("specializations", element));
            Adapters.INT.writeJson(this.index).ifPresent(element -> json.add("index", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.specializations = Arrays.stream((Skill[])SPECIALIZATIONS.readJson(json.get("specializations")).orElseThrow()).map(skill -> (LearnableSkill)skill).collect(Collectors.toList());
        this.index = Adapters.INT.readJson(json.get("index")).orElse(0);
        this.specializations.forEach(specialization -> specialization.setParent(this));
    }
}

