/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.base;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.ability.AbilityLevelAttribute;
import iskallia.vault.gear.attribute.talent.TalentLevelAttribute;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.skill.ability.effect.spi.core.Cooldown;
import iskallia.vault.skill.ability.effect.spi.core.CooldownSkill;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.TickingSkill;
import iskallia.vault.skill.prestige.MasterfulPrestigePower;
import iskallia.vault.skill.prestige.core.ActivatePrestigePower;
import iskallia.vault.skill.prestige.core.PrestigePower;
import iskallia.vault.skill.prestige.helper.PrestigeHelper;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.skill.tree.TalentTree;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.MiscUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class TieredSkill
extends LearnableSkill
implements TickingSkill,
CooldownSkill {
    private List<LearnableSkill> tiers;
    private int maxLearnableTier;
    private int tier;
    private int bonusTier;
    private static final ArrayAdapter<Skill> TIERS = Adapters.ofArray(Skill[]::new, Adapters.SKILL);

    public TieredSkill(int unlockLevel, int learnPointCost, int regretPointCost, Stream<LearnableSkill> tiers) {
        super(unlockLevel, learnPointCost, regretPointCost);
        this.tiers = tiers.toList();
        this.maxLearnableTier = this.tiers.size();
        this.tiers.forEach(tier -> tier.setParent(this));
    }

    public List<LearnableSkill> getTiers() {
        return this.tiers;
    }

    public TieredSkill() {
    }

    public int getUnmodifiedTier() {
        return this.tier;
    }

    public int getActualTier() {
        return this.tier + this.bonusTier;
    }

    public int getMaxLearnableTier() {
        return this.maxLearnableTier;
    }

    public LearnableSkill getChild() {
        return this.getChild(this.getActualTier());
    }

    public LearnableSkill getChild(int tier) {
        if (tier <= 0) {
            return null;
        }
        return MiscUtils.getListEntrySafe(this.tiers, tier - 1);
    }

    @Override
    public void onTick(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> this.updateBonusTier(AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)player), context.copy()));
    }

    public void updateBonusTier(AttributeSnapshot snapshot, SkillContext context) {
        int additional = 0;
        boolean masterful = context.getSource().as(ServerPlayer.class).map(player -> !PrestigeHelper.getPrestige((Player)player).getAll(MasterfulPrestigePower.class, Skill::isUnlocked).isEmpty()).orElse(false);
        for (VaultGearAttribute<TalentLevelAttribute> attribute : List.of(ModGearAttributes.ABILITY_LEVEL, ModGearAttributes.TALENT_LEVEL)) {
            List<TalentLevelAttribute> values = snapshot.getAttributeValueList(attribute);
            block1: for (TalentLevelAttribute value : values) {
                String target;
                int levelChange = 0;
                if (value instanceof AbilityLevelAttribute) {
                    AbilityLevelAttribute abilityAttribute = (AbilityLevelAttribute)((Object)value);
                    target = abilityAttribute.getAbility();
                    if (masterful && (levelChange += abilityAttribute.getLevelChange()) > 0) {
                        levelChange += abilityAttribute.getLevelChange();
                    }
                } else {
                    if (!(value instanceof TalentLevelAttribute)) continue;
                    TalentLevelAttribute talentAttribute = value;
                    target = talentAttribute.getTalent();
                    levelChange += talentAttribute.getLevelChange();
                }
                if (target.equals("all_abilities") && this.hasParentOfType(AbilityTree.class) || target.equals("all_talents") && this.hasParentOfType(TalentTree.class)) {
                    additional += levelChange;
                    continue;
                }
                Skill current = this;
                do {
                    if (!target.equals(current.getId())) continue;
                    additional += levelChange;
                    continue block1;
                } while ((current = current.getParent()) != null);
            }
        }
        this.updateBonusTier(additional, context);
    }

    protected void updateBonusTier(int bonusTier, SkillContext context) {
        if (this.bonusTier != bonusTier) {
            if (this.tier > 0 && this.tier + this.bonusTier > 0) {
                this.regretCurrentTier(context);
            }
            this.bonusTier = bonusTier;
            if (this.tier > 0 && this.tier + this.bonusTier > 0) {
                this.learnCurrentTier(context);
            }
        }
    }

    @Override
    public int getUnlockLevel() {
        return this.tier >= this.tiers.size() ? 0 : this.tiers.get(this.tier).getUnlockLevel();
    }

    @Override
    public int getLearnPointCost() {
        return this.tier >= this.tiers.size() ? 0 : this.tiers.get(this.tier).getLearnPointCost();
    }

    @Override
    public int getSpentLearnPoints() {
        return this.getSpentLearnPoints(this.tier);
    }

    public int getSpentLearnPoints(int tier) {
        int points = 0;
        for (int i = 0; i < tier; ++i) {
            points += this.tiers.get(i).getLearnPointCost();
        }
        return points;
    }

    @Override
    public int getRegretCost() {
        return this.tier <= 0 ? 0 : this.tiers.get(this.tier - 1).getRegretCost();
    }

    @Override
    public boolean isUnlocked() {
        return this.getUnmodifiedTier() > 0;
    }

    @Override
    public boolean canLearn(SkillContext context) {
        return this.tier < this.maxLearnableTier && this.tiers.get(this.tier).canLearn(context);
    }

    public boolean canLearn(SkillContext context, boolean ignoreMaxTier) {
        return (ignoreMaxTier || this.tier < this.maxLearnableTier) && this.tiers.get(this.tier).canLearn(context);
    }

    @Override
    public void learn(SkillContext context) {
        if (this.tier > 0) {
            this.regretCurrentTier(context.copy());
        }
        ++this.tier;
        this.learnCurrentTier(context);
    }

    public void learn(SkillContext context, boolean ignoreMaxTier) {
        if (this.tier > 0) {
            this.regretCurrentTier(context.copy());
        }
        if (!ignoreMaxTier && this.tier >= this.maxLearnableTier) {
            throw new IllegalStateException();
        }
        ++this.tier;
        this.learnCurrentTier(context);
    }

    @Override
    public boolean canRegret(SkillContext context) {
        return this.tier > 0 && this.tiers.get(this.tier - 1).canRegret(context);
    }

    @Override
    public void regret(SkillContext context) {
        this.regretCurrentTier(context);
        if (this.tier <= 0) {
            throw new IllegalStateException();
        }
        --this.tier;
        if (this.tier > 0) {
            this.learnCurrentTier(context.copy());
        }
    }

    private void regretCurrentTier(SkillContext context) {
        MiscUtils.getListEntrySafe(this.tiers, this.tier + this.bonusTier - 1).regret(context);
    }

    private void learnCurrentTier(SkillContext context) {
        MiscUtils.getListEntrySafe(this.tiers, this.tier + this.bonusTier - 1).learn(context);
    }

    @Override
    public Optional<Skill> getForId(String id) {
        return super.getForId(id).or(() -> {
            for (Skill skill : this.tiers) {
                Skill skill2 = skill.getForId(id).orElse(null);
                if (skill2 == null) continue;
                return Optional.of(skill2);
            }
            return Optional.empty();
        });
    }

    public int getTierOf(String id) {
        for (int i = 0; i < this.tiers.size(); ++i) {
            if (!this.tiers.get(i).getId().equals(id)) continue;
            return i + 1;
        }
        return 0;
    }

    @Override
    public <T> void iterate(Class<T> type, Consumer<T> action) {
        super.iterate(type, action);
        for (LearnableSkill child : this.tiers) {
            child.iterate(type, action);
        }
    }

    @Override
    public Skill mergeFrom(Skill other, SkillContext context) {
        boolean isPrestigePower;
        if (!(other instanceof TieredSkill)) {
            int spentPoints = this.getSpentLearnPoints();
            context.setLearnPoints(context.getLearnPoints() + spentPoints);
            return other;
        }
        TieredSkill tiered = (TieredSkill)other;
        boolean bl = isPrestigePower = !this.tiers.isEmpty() && this.tiers.get(0) instanceof PrestigePower;
        if (isPrestigePower) {
            int highestLearnedTier = 0;
            for (int i = 0; i < this.tiers.size(); ++i) {
                if (!this.tiers.get(i).isUnlocked()) continue;
                highestLearnedTier = i + 1;
            }
            if (highestLearnedTier > 0) {
                tiered.tier = highestLearnedTier;
                if (highestLearnedTier <= tiered.tiers.size()) {
                    LearnableSkill savedTier = this.tiers.get(highestLearnedTier - 1);
                    LearnableSkill configTier = tiered.tiers.get(highestLearnedTier - 1);
                    if (savedTier instanceof ActivatePrestigePower) {
                        ActivatePrestigePower savedActivate = (ActivatePrestigePower)savedTier;
                        if (configTier instanceof ActivatePrestigePower) {
                            ActivatePrestigePower configActivate = (ActivatePrestigePower)configTier;
                            configActivate.setActive(savedActivate.isActive());
                        }
                    }
                    configTier.setPresent(true, context.copy());
                }
            }
            return tiered;
        }
        int spentPoints = this.getSpentLearnPoints();
        int previousPoints = context.getLearnPoints();
        context.setLearnPoints(spentPoints);
        while (tiered.canLearn(context)) {
            tiered.learn(context);
        }
        context.setLearnPoints(context.getLearnPoints() + previousPoints);
        return tiered;
    }

    @Override
    public Optional<Cooldown> getCooldown() {
        Cooldown max = null;
        for (LearnableSkill child : this.tiers) {
            Cooldown cooldown;
            if (!(child instanceof CooldownSkill) || (cooldown = (Cooldown)((CooldownSkill)((Object)child)).getCooldown().orElse(null)) == null || max != null && !cooldown.isLargerThan(max)) continue;
            max = cooldown;
        }
        return Optional.ofNullable(max);
    }

    @Override
    public void putOnCooldown(int cooldownDelayTicks, SkillContext context) {
        LearnableSkill child = this.getChild();
        if (child instanceof CooldownSkill) {
            ((CooldownSkill)((Object)child)).putOnCooldown(cooldownDelayTicks, context);
        }
    }

    @Override
    public <T extends Skill> T copy() {
        TieredSkill copy = new TieredSkill(this.unlockLevel, this.learnPointCost, this.regretCost, this.tiers.stream().map(Skill::copy));
        copy.parent = this.parent;
        copy.id = this.id;
        copy.name = this.name;
        copy.present = this.present;
        copy.learnPointCost = this.learnPointCost;
        copy.regretCost = this.regretCost;
        copy.unlockLevel = this.unlockLevel;
        copy.tier = this.tier;
        copy.bonusTier = this.bonusTier;
        copy.maxLearnableTier = this.maxLearnableTier;
        return (T)copy;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        TIERS.writeBits((Skill)((Skill[])this.tiers.toArray(Skill[]::new)), buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.maxLearnableTier, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.tier, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.bonusTier, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.tiers = Arrays.stream((Skill[])TIERS.readBits(buffer).orElseThrow()).map(skill -> (LearnableSkill)skill).toList();
        this.maxLearnableTier = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        this.tier = Adapters.INT_SEGMENTED_3.readBits(buffer).orElse(0);
        this.bonusTier = Adapters.INT_SEGMENTED_3.readBits(buffer).orElse(0);
        this.tiers.forEach(tier -> tier.setParent(this));
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            TIERS.writeNbt((Skill)((Skill[])this.tiers.toArray(Skill[]::new))).ifPresent(tag -> nbt.m_128365_("tiers", tag));
            Adapters.INT.writeNbt(this.maxLearnableTier).ifPresent(tag -> nbt.m_128365_("maxLearnableTier", tag));
            Adapters.INT.writeNbt(this.tier).ifPresent(tag -> nbt.m_128365_("tier", tag));
            Adapters.INT.writeNbt(this.bonusTier).ifPresent(tag -> nbt.m_128365_("bonusTier", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.tiers = Arrays.stream((Skill[])TIERS.readNbt(nbt.m_128423_("tiers")).orElseThrow()).map(skill -> (LearnableSkill)skill).toList();
        this.maxLearnableTier = Adapters.INT.readNbt(nbt.m_128423_("maxLearnableTier")).orElse(this.tiers.size());
        this.tier = Adapters.INT.readNbt(nbt.m_128423_("tier")).orElse(0);
        this.bonusTier = Adapters.INT.readNbt(nbt.m_128423_("bonusTier")).orElse(0);
        this.tiers.forEach(tier -> tier.setParent(this));
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            TIERS.writeJson((Skill)((Skill[])this.tiers.toArray(Skill[]::new))).ifPresent(element -> json.add("tiers", element));
            Adapters.INT.writeJson(this.maxLearnableTier).ifPresent(element -> json.add("maxLearnableTier", element));
            Adapters.INT.writeJson(this.tier).ifPresent(element -> json.add("tier", element));
            Adapters.INT.writeJson(this.bonusTier).ifPresent(element -> json.add("bonusTier", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.tiers = Arrays.stream((Skill[])TIERS.readJson(json.get("tiers")).orElseThrow()).map(skill -> (LearnableSkill)skill).toList();
        this.maxLearnableTier = Adapters.INT.readJson(json.get("maxLearnableTier")).orElse(this.tiers.size());
        this.tier = Adapters.INT.readJson(json.get("tier")).orElse(0);
        this.bonusTier = Adapters.INT.readJson(json.get("bonusTier")).orElse(0);
        this.tiers.forEach(tier -> tier.setParent(this));
    }
}

