/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.expertise.type;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.event.event.ShopPedestalPriceEvent;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.tree.ExpertiseTree;
import iskallia.vault.world.data.PlayerExpertisesData;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BarteringExpertise
extends LearnableSkill {
    private float costReduction;

    public BarteringExpertise(int unlockLevel, int learnPointCost, int regretPointCost, float costReduction) {
        super(unlockLevel, learnPointCost, regretPointCost);
        this.costReduction = costReduction;
    }

    public BarteringExpertise() {
    }

    public float getCostReduction() {
        return this.costReduction;
    }

    @SubscribeEvent
    public static void adjustPrice(ShopPedestalPriceEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ExpertiseTree expertises = PlayerExpertisesData.get(player2.m_183503_()).getExpertises((Player)player2);
            float costReduction = 0.0f;
            for (BarteringExpertise expertise : expertises.getAll(BarteringExpertise.class, Skill::isUnlocked)) {
                costReduction += expertise.getCostReduction();
            }
            float multiplier = 1.0f - costReduction;
            ItemStack costStack = event.getCost().m_41777_();
            costStack.m_41764_(Mth.m_14143_((float)((float)costStack.m_41613_() * multiplier)));
            event.setNewCost(costStack);
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.costReduction), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.costReduction = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.costReduction)).ifPresent(tag -> nbt.m_128365_("costReduction", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.costReduction = ((Float)Adapters.FLOAT.readNbt(nbt.m_128423_("costReduction")).orElseThrow()).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.costReduction)).ifPresent(element -> json.add("costReduction", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.costReduction = ((Float)Adapters.FLOAT.readJson(json.get("costReduction")).orElseThrow()).floatValue();
    }
}

