/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.expertise.type;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.base.LearnableSkill;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;

public class CompanionCooldownExpertise
extends LearnableSkill {
    private float cooldownReduction;

    public CompanionCooldownExpertise(int unlockLevel, int learnPointCost, int regretPointCost, float cooldownReduction) {
        super(unlockLevel, learnPointCost, regretPointCost);
        this.cooldownReduction = cooldownReduction;
    }

    public CompanionCooldownExpertise() {
    }

    public float getCooldownReduction() {
        return this.cooldownReduction;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.cooldownReduction), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.cooldownReduction = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.cooldownReduction)).ifPresent(tag -> nbt.m_128365_("cooldownReduction", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.cooldownReduction = ((Float)Adapters.FLOAT.readNbt(nbt.m_128423_("cooldownReduction")).orElseThrow()).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.cooldownReduction)).ifPresent(element -> json.add("cooldownReduction", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.cooldownReduction = ((Float)Adapters.FLOAT.readJson(json.get("cooldownReduction")).orElseThrow()).floatValue();
    }
}

