/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.expertise.type;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.tree.ExpertiseTree;
import iskallia.vault.world.data.PlayerExpertisesData;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ExperiencedExpertise
extends LearnableSkill {
    private float increasedExpPercentage;

    public ExperiencedExpertise(int unlockLevel, int learnPointCost, int regretPointCost, float increasedExpPercentage) {
        super(unlockLevel, learnPointCost, regretPointCost);
        this.increasedExpPercentage = increasedExpPercentage;
    }

    public ExperiencedExpertise() {
    }

    public float getIncreasedExpPercentage() {
        return this.increasedExpPercentage;
    }

    @SubscribeEvent
    public static void onOrbPickup(PlayerXpEvent.PickupXp event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ExpertiseTree expertises = PlayerExpertisesData.get(player2.m_183503_()).getExpertises((Player)player2);
        ExperienceOrb orb = event.getOrb();
        float increase = 0.0f;
        for (ExperiencedExpertise expertise : expertises.getAll(ExperiencedExpertise.class, Skill::isUnlocked)) {
            increase += expertise.getIncreasedExpPercentage();
        }
        orb.f_20770_ = (int)((float)orb.f_20770_ * (1.0f + increase));
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.increasedExpPercentage), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.increasedExpPercentage = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.increasedExpPercentage)).ifPresent(tag -> nbt.m_128365_("increasedExpPercentage", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.increasedExpPercentage = ((Float)Adapters.FLOAT.readNbt(nbt.m_128423_("increasedExpPercentage")).orElseThrow()).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.increasedExpPercentage)).ifPresent(element -> json.add("increasedExpPercentage", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.increasedExpPercentage = ((Float)Adapters.FLOAT.readJson(json.get("increasedExpPercentage")).orElseThrow()).floatValue();
    }
}

