/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.expertise.type;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.TickingSkill;
import iskallia.vault.util.AABBHelper;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BambooBlock;
import net.minecraft.world.level.block.BambooSaplingBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.ticks.TickPriority;
import net.minecraftforge.common.ForgeHooks;

public class FarmerTwerker
extends LearnableSkill
implements TickingSkill {
    private static final int PARTICLE_COUNT = 20;
    private static final Predicate<AgeableMob> AGEABLE_MOB_PREDICATE = entity -> entity.m_6084_() && !entity.m_5833_() && entity.m_6162_();
    private int tickDelay;
    private int horizontalRange;
    private int verticalRange;
    private float adultChance;
    private int tick;

    public FarmerTwerker(int unlockLevel, int learnPointCost, int regretPointCost) {
        super(unlockLevel, learnPointCost, regretPointCost);
        this.tickDelay = this.tickDelay;
        this.horizontalRange = this.horizontalRange;
        this.verticalRange = this.verticalRange;
        this.tick = 0;
    }

    public FarmerTwerker() {
    }

    public int getTickDelay() {
        return this.tickDelay;
    }

    public int getHorizontalRange() {
        return this.horizontalRange;
    }

    public int getVerticalRange() {
        return this.verticalRange;
    }

    public float getAdultChance() {
        return this.adultChance;
    }

    @Override
    public void onTick(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            if (!this.isUnlocked()) {
                return;
            }
            if (VaultUtils.isVaultLevel(player.f_19853_)) {
                return;
            }
            if (this.tick > 0) {
                --this.tick;
                return;
            }
            this.tick = this.getTickDelay();
            if (!player.m_6144_()) {
                return;
            }
            this.doGrow((ServerPlayer)player, (ServerLevel)player.f_19853_);
        });
    }

    protected void doGrow(ServerPlayer player, ServerLevel world) {
        Block block;
        BlockPos playerPos = player.m_142538_();
        int originalHorizontalRange = this.getHorizontalRange();
        int originalVerticalRange = this.getVerticalRange();
        int horizontalRange = originalHorizontalRange;
        int verticalRange = originalVerticalRange;
        horizontalRange = AreaOfEffectHelper.adjustAreaOfEffectRound((LivingEntity)player, this, horizontalRange);
        verticalRange = AreaOfEffectHelper.adjustAreaOfEffectRound((LivingEntity)player, this, verticalRange);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        ArrayList<BlockPos> candidateList = new ArrayList<BlockPos>();
        for (int x = -horizontalRange; x <= horizontalRange; ++x) {
            for (int z = -horizontalRange; z <= horizontalRange; ++z) {
                for (int y = -verticalRange; y <= verticalRange; ++y) {
                    mutableBlockPos.m_122178_(playerPos.m_123341_() + x, playerPos.m_123342_() + y, playerPos.m_123343_() + z);
                    BlockState blockState = world.m_8055_((BlockPos)mutableBlockPos);
                    block = blockState.m_60734_();
                    if (!this.canGrowBlock(world, (BlockPos)mutableBlockPos, block, blockState)) continue;
                    candidateList.add(new BlockPos((Vec3i)mutableBlockPos));
                }
            }
        }
        if (!candidateList.isEmpty()) {
            int executionAttempts = Math.max(1, originalHorizontalRange * originalVerticalRange / (horizontalRange * verticalRange));
            for (int i = 0; i < executionAttempts; ++i) {
                BlockPos pos = (BlockPos)candidateList.get(world.m_5822_().nextInt(candidateList.size()));
                BlockState state = world.m_8055_(pos);
                block = world.m_8055_(pos).m_60734_();
                this.doGrowBlock(player, world, pos, block, state);
            }
        }
        AABB searchBox = AABBHelper.create(player.m_20182_(), horizontalRange, verticalRange, horizontalRange);
        List entities = world.m_6443_(AgeableMob.class, searchBox, AGEABLE_MOB_PREDICATE);
        for (AgeableMob entity : entities) {
            if (world.m_5822_().nextFloat() < 0.4f) {
                world.m_8767_((ParticleOptions)ParticleTypes.f_123748_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 20, 0.5, 0.5, 0.5, 0.0);
            }
            if (!(world.m_5822_().nextFloat() < this.getAdultChance())) continue;
            entity.m_6863_(false);
        }
    }

    protected boolean canGrowBlock(ServerLevel world, BlockPos pos, Block block, BlockState blockState) {
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            return cropBlock.m_7370_((BlockGetter)world, pos, blockState, false);
        }
        if (block instanceof SaplingBlock) {
            SaplingBlock saplingBlock = (SaplingBlock)block;
            return saplingBlock.m_7370_((BlockGetter)world, pos, blockState, false);
        }
        if (block instanceof SugarCaneBlock || block instanceof CactusBlock) {
            if (!world.m_46859_(pos.m_7494_())) {
                return false;
            }
            int height = 1;
            while (world.m_8055_(pos.m_6625_(height)).m_60713_(block)) {
                ++height;
            }
            return height < 3;
        }
        if (block instanceof BambooBlock) {
            BambooBlock bambooBlock = (BambooBlock)block;
            if (world.m_8055_(pos.m_7495_()).m_60713_(block)) {
                return false;
            }
            return bambooBlock.m_7370_((BlockGetter)world, pos, blockState, false);
        }
        if (block instanceof BambooSaplingBlock) {
            BambooSaplingBlock bambooSaplingBlock = (BambooSaplingBlock)block;
            if (!world.m_46859_(pos.m_7494_())) {
                return false;
            }
            return bambooSaplingBlock.m_7370_((BlockGetter)world, pos, blockState, false);
        }
        if (block instanceof NetherWartBlock) {
            return (Integer)blockState.m_61143_((Property)NetherWartBlock.f_54967_) < 3;
        }
        if (block instanceof SweetBerryBushBlock) {
            SweetBerryBushBlock sweetBerryBushBlock = (SweetBerryBushBlock)block;
            return sweetBerryBushBlock.m_7370_((BlockGetter)world, pos, blockState, false);
        }
        return block instanceof StemBlock;
    }

    protected void doGrowBlock(ServerPlayer player, ServerLevel world, BlockPos pos, Block block, BlockState blockState) {
        if (block instanceof CropBlock || block instanceof SaplingBlock) {
            BoneMealItem.applyBonemeal((ItemStack)new ItemStack((ItemLike)Items.f_42499_), (Level)world, (BlockPos)pos, (Player)player);
            world.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 20, 0.5, 0.5, 0.5, 0.0);
        } else if (block instanceof SugarCaneBlock || block instanceof CactusBlock) {
            BlockPos above = pos.m_7494_();
            if (ForgeHooks.onCropsGrowPre((Level)world, (BlockPos)pos, (BlockState)blockState, (boolean)true)) {
                world.m_46597_(above, block.m_49966_());
                BlockState newState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61410_, (Comparable)Integer.valueOf(0));
                world.m_7731_(pos, newState, 4);
                newState.m_60690_((Level)world, above, block, pos, false);
                world.m_186464_(above, block, 1, TickPriority.EXTREMELY_HIGH);
                ForgeHooks.onCropsGrowPost((Level)world, (BlockPos)above, (BlockState)blockState);
                world.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 20, 0.5, 0.5, 0.5, 0.0);
            }
        } else if (block instanceof BambooBlock || block instanceof BambooSaplingBlock) {
            Block newState = blockState.m_60734_();
            if (newState instanceof BonemealableBlock) {
                BonemealableBlock bonemealableBlock = (BonemealableBlock)newState;
                bonemealableBlock.m_7719_(world, world.f_46441_, pos, blockState);
            }
            BlockPos bambooBlockPos = pos.m_7494_();
            ArrayList<BlockPos> particlePosList = new ArrayList<BlockPos>();
            while (world.m_8055_(bambooBlockPos).m_60713_(block)) {
                particlePosList.add(bambooBlockPos);
                bambooBlockPos = bambooBlockPos.m_7494_();
            }
            for (BlockPos blockPos : particlePosList) {
                world.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, Math.max(1, 20 / particlePosList.size()), 0.5, 0.5, 0.5, 0.0);
            }
        } else if (block instanceof NetherWartBlock) {
            BlockState state = world.m_8055_(pos);
            if (ForgeHooks.onCropsGrowPre((Level)world, (BlockPos)pos, (BlockState)state, (boolean)true)) {
                state = (BlockState)state.m_61124_((Property)NetherWartBlock.f_54967_, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)NetherWartBlock.f_54967_) + 1));
                world.m_7731_(pos, state, 2);
                ForgeHooks.onCropsGrowPost((Level)world, (BlockPos)pos, (BlockState)state);
            }
            world.m_8767_((ParticleOptions)ParticleTypes.f_123746_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 10, 0.5, 0.5, 0.5, 0.0);
        } else if (block instanceof StemBlock) {
            StemBlock stemBlock = (StemBlock)block;
            if (stemBlock.m_7370_((BlockGetter)world, pos, blockState, false)) {
                BoneMealItem.applyBonemeal((ItemStack)new ItemStack((ItemLike)Items.f_42499_), (Level)world, (BlockPos)pos, (Player)player);
            } else {
                for (int i = 0; i < 40; ++i) {
                    blockState.m_60735_(world, pos, world.f_46441_);
                }
            }
            world.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 20, 0.5, 0.5, 0.5, 0.0);
        } else if (block instanceof SweetBerryBushBlock) {
            BoneMealItem.applyBonemeal((ItemStack)new ItemStack((ItemLike)Items.f_42499_), (Level)world, (BlockPos)pos, (Player)player);
            world.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 20, 0.5, 0.5, 0.5, 0.0);
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.tickDelay, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.horizontalRange, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.verticalRange, buffer);
        Adapters.INT.writeBits(this.tick, buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.adultChance), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.tickDelay = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        this.horizontalRange = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        this.verticalRange = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        this.tick = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
        this.adultChance = Adapters.FLOAT.readBits(buffer).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.tickDelay).ifPresent(tag -> nbt.m_128365_("tickDelay", tag));
            Adapters.INT.writeNbt(this.horizontalRange).ifPresent(tag -> nbt.m_128365_("horizontalRange", tag));
            Adapters.INT.writeNbt(this.verticalRange).ifPresent(tag -> nbt.m_128365_("verticalRange", tag));
            Adapters.INT.writeNbt(this.tick).ifPresent(tag -> nbt.m_128365_("tick", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.adultChance)).ifPresent(tag -> nbt.m_128365_("adultChance", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.tickDelay = Adapters.INT.readNbt(nbt.m_128423_("tickDelay")).orElse(0);
        this.horizontalRange = Adapters.INT.readNbt(nbt.m_128423_("horizontalRange")).orElse(0);
        this.verticalRange = Adapters.INT.readNbt(nbt.m_128423_("verticalRange")).orElse(0);
        this.tick = Adapters.INT.readNbt(nbt.m_128423_("tick")).orElse(0);
        this.adultChance = Adapters.FLOAT.readNbt(nbt.m_128423_("adultChance")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.tickDelay).ifPresent(element -> json.add("tickDelay", element));
            Adapters.INT.writeJson(this.horizontalRange).ifPresent(element -> json.add("horizontalRange", element));
            Adapters.INT.writeJson(this.verticalRange).ifPresent(element -> json.add("verticalRange", element));
            Adapters.INT.writeJson(this.tick).ifPresent(element -> json.add("tick", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.adultChance)).ifPresent(element -> json.add("adultChance", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.tickDelay = Adapters.INT.readJson(json.get("tickDelay")).orElse(0);
        this.horizontalRange = Adapters.INT.readJson(json.get("horizontalRange")).orElse(0);
        this.verticalRange = Adapters.INT.readJson(json.get("verticalRange")).orElse(0);
        this.tick = Adapters.INT.readJson(json.get("tick")).orElse(0);
        this.adultChance = Adapters.FLOAT.readJson(json.get("adultChance")).orElse(Float.valueOf(0.0f)).floatValue();
    }
}

