/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.expertise.type;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.skill.ability.effect.spi.AbstractVeinMinerAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.util.BlockBreakHandler;
import iskallia.vault.util.OverlevelEnchantHelper;
import iskallia.vault.world.data.PlayerAbilitiesData;
import iskallia.vault.world.data.PlayerExpertisesData;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FortunateExpertise
extends LearnableSkill {
    private static final BlockBreakHandler blockBreakHandler = new BlockBreakHandler(){

        @Override
        protected int getBlockLimit(Player player) {
            return 1;
        }

        @Override
        protected ItemStack getMiningItemProxy(Player player) {
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND).m_41777_();
            return OverlevelEnchantHelper.increaseFortuneBy(stack, this.getAdditionalFortuneLevels(player));
        }

        private int getAdditionalFortuneLevels(Player player) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                return PlayerExpertisesData.get(serverPlayer.m_183503_()).getExpertises((Player)serverPlayer).getAll(FortunateExpertise.class, Skill::isUnlocked).stream().mapToInt(FortunateExpertise::getAdditionalFortuneLevels).sum();
            }
            return 0;
        }

        @Override
        protected boolean shouldVoid(ServerLevel level, ServerPlayer player, BlockState blockState) {
            return PlayerAbilitiesData.get(player.m_183503_()).getAbilities((Player)player).getAll(AbstractVeinMinerAbility.class, Ability::isActive).stream().findFirst().map(ability -> ability.shouldVoid(level, player, blockState)).orElse(false);
        }
    };
    private int additionalFortuneLevels;

    @SubscribeEvent
    public static void onBlockMined(BlockEvent.BreakEvent event) {
        ServerLevel level;
        ServerPlayer player;
        block3: {
            block2: {
                Player player2;
                if (event.getWorld().m_5776_() || event.getPlayer() instanceof FakePlayer || !((player2 = event.getPlayer()) instanceof ServerPlayer)) break block2;
                player = (ServerPlayer)player2;
                player2 = event.getWorld();
                if (!(player2 instanceof ServerLevel)) break block2;
                level = (ServerLevel)player2;
                if (event.getPlayer().m_7655_() == InteractionHand.MAIN_HAND && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)event.getPlayer().m_21205_()) > 0) break block3;
            }
            return;
        }
        ActiveFlags.IS_FORTUNE_MINING.runIfNotSet(() -> {
            BlockState blockState;
            if (PlayerExpertisesData.get(level).getExpertises((Player)player).getAll(FortunateExpertise.class, Skill::isUnlocked).isEmpty()) {
                return;
            }
            BlockPos pos = event.getPos();
            if (blockBreakHandler.areaDig(level, player, pos, (blockState = level.m_8055_(pos)).m_60734_())) {
                event.setCanceled(true);
            }
        });
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT.writeBits(this.additionalFortuneLevels, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.additionalFortuneLevels = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.additionalFortuneLevels).ifPresent(tag -> nbt.m_128365_("additionalFortuneLevels", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.additionalFortuneLevels = (Integer)Adapters.INT.readNbt(nbt.m_128423_("additionalFortuneLevels")).orElseThrow();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.additionalFortuneLevels).ifPresent(element -> json.add("additionalFortuneLevels", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.additionalFortuneLevels = (Integer)Adapters.INT.readJson(json.get("additionalFortuneLevels")).orElseThrow();
    }

    public int getAdditionalFortuneLevels() {
        return this.additionalFortuneLevels;
    }
}

