/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.prestige;

import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.prestige.core.PrestigePower;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;

public class BlackMarketRerollsPrestigePowerPower
extends PrestigePower {
    private int extraRerolls;

    public BlackMarketRerollsPrestigePowerPower() {
        this.extraRerolls = 5;
    }

    public BlackMarketRerollsPrestigePowerPower(int extraRerolls) {
        this.extraRerolls = extraRerolls;
    }

    public BlackMarketRerollsPrestigePowerPower(int unlockLevel, int learnPointCost, int knowledgeCost, int regretCost, int extraRerolls) {
        super(unlockLevel, learnPointCost, knowledgeCost, regretCost);
        this.extraRerolls = extraRerolls;
    }

    public int getExtraRerolls() {
        return this.extraRerolls;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT.writeBits(this.extraRerolls, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.extraRerolls = Adapters.INT.readBits(buffer).orElse(5);
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.extraRerolls).ifPresent(tag -> nbt.m_128365_("extraRerolls", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.extraRerolls = Adapters.INT.readNbt(nbt.m_128423_("extraRerolls")).orElse(5);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.extraRerolls).ifPresent(element -> json.add("extraRerolls", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.extraRerolls = Adapters.INT.readJson(json.get("extraRerolls")).orElse(5);
    }

    @Override
    public void writeBytes(ByteBuf buffer) {
        super.writeBytes(buffer);
        Adapters.INT.writeBytes(this.extraRerolls, buffer);
    }

    @Override
    public void readBytes(ByteBuf buffer) {
        super.readBytes(buffer);
        this.extraRerolls = Adapters.INT.readBytes(buffer).orElse(5);
    }
}

