/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.prestige;

import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.prestige.core.PrestigePower;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;

public class BountyCooldownReductionPrestigePower
extends PrestigePower {
    private int minutesReduction;

    public BountyCooldownReductionPrestigePower() {
        this.minutesReduction = 1000;
    }

    public BountyCooldownReductionPrestigePower(int minutesReduction) {
        this.minutesReduction = minutesReduction;
    }

    public BountyCooldownReductionPrestigePower(int unlockLevel, int learnPointCost, int regretCost, int minutesReduction) {
        super(unlockLevel, learnPointCost, regretCost);
        this.minutesReduction = minutesReduction;
    }

    public int getMinutesReduction() {
        return this.minutesReduction;
    }

    public boolean removesAllCooldown() {
        return this.minutesReduction >= 1000;
    }

    public long getReducedCooldown(long originalSeconds) {
        if (this.removesAllCooldown()) {
            return 0L;
        }
        long reductionSeconds = (long)this.minutesReduction * 60L;
        return Math.max(0L, originalSeconds - reductionSeconds);
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT.writeBits(this.minutesReduction, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.minutesReduction = Adapters.INT.readBits(buffer).orElse(1000);
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.minutesReduction).ifPresent(tag -> nbt.m_128365_("minutesReduction", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.minutesReduction = Adapters.INT.readNbt(nbt.m_128423_("minutesReduction")).orElse(1000);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.minutesReduction).ifPresent(element -> json.add("minutesReduction", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.minutesReduction = Adapters.INT.readJson(json.get("minutesReduction")).orElse(1000);
    }

    @Override
    public void writeBytes(ByteBuf buffer) {
        super.writeBytes(buffer);
        Adapters.INT.writeBytes(this.minutesReduction, buffer);
    }

    @Override
    public void readBytes(ByteBuf buffer) {
        super.readBytes(buffer);
        this.minutesReduction = Adapters.INT.readBytes(buffer).orElse(1000);
    }
}

