/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.prestige;

import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.prestige.core.PrestigePower;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;

public class CommanderPrestigePower
extends PrestigePower {
    private float durationMultiplier;

    public CommanderPrestigePower() {
        this.durationMultiplier = 2.0f;
    }

    public CommanderPrestigePower(float durationMultiplier) {
        this.durationMultiplier = durationMultiplier;
    }

    public CommanderPrestigePower(int unlockLevel, int learnPointCost, int regretCost, float durationMultiplier) {
        super(unlockLevel, learnPointCost, regretCost);
        this.durationMultiplier = durationMultiplier;
    }

    public float getDurationMultiplier() {
        return this.durationMultiplier;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.durationMultiplier), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.durationMultiplier = Adapters.FLOAT.readBits(buffer).orElse(Float.valueOf(2.0f)).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.durationMultiplier)).ifPresent(tag -> nbt.m_128365_("durationMultiplier", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.durationMultiplier = Adapters.FLOAT.readNbt(nbt.m_128423_("durationMultiplier")).orElse(Float.valueOf(2.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.durationMultiplier)).ifPresent(element -> json.add("durationMultiplier", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.durationMultiplier = Adapters.FLOAT.readJson(json.get("durationMultiplier")).orElse(Float.valueOf(2.0f)).floatValue();
    }

    @Override
    public void writeBytes(ByteBuf buffer) {
        super.writeBytes(buffer);
        Adapters.FLOAT.writeBytes(Float.valueOf(this.durationMultiplier), buffer);
    }

    @Override
    public void readBytes(ByteBuf buffer) {
        super.readBytes(buffer);
        this.durationMultiplier = Adapters.FLOAT.readBytes(buffer).orElse(Float.valueOf(2.0f)).floatValue();
    }
}

