/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.prestige;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.TickingSkill;
import iskallia.vault.skill.prestige.core.PrestigePower;
import iskallia.vault.skill.prestige.helper.PrestigeHelper;
import iskallia.vault.skill.source.EntitySkillSource;
import iskallia.vault.skill.source.SkillSource;
import iskallia.vault.skill.talent.GearAttributeSkill;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class GearAttributePrestigePower
extends PrestigePower
implements GearAttributeSkill,
TickingSkill {
    private VaultGearAttribute<?> attribute;
    private double value;

    public GearAttributePrestigePower(int unlockLevel, int learnPointCost, int learnKnowledgeCost, int regretPointCost, VaultGearAttribute<?> attribute, double value) {
        super(unlockLevel, learnPointCost, learnKnowledgeCost, regretPointCost);
        this.attribute = attribute;
        this.value = value;
    }

    public GearAttributePrestigePower() {
    }

    public VaultGearAttribute<?> getAttribute() {
        return this.attribute;
    }

    public double getValue() {
        return this.value;
    }

    public boolean canApply(SkillContext context) {
        return this.isUnlocked();
    }

    @Override
    public void onAdd(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(this::refreshSnapshot);
    }

    @Override
    public void onRemove(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(this::refreshSnapshot);
    }

    @Override
    public void onTick(SkillContext context) {
        EntitySkillSource entitySkillSource;
        SkillSource skillSource = context.getSource();
        if (skillSource instanceof EntitySkillSource && (entitySkillSource = (EntitySkillSource)skillSource).as(Player.class).map(PrestigeHelper::arePrestigePowersDisabled).orElse(false).booleanValue()) {
            this.onRemoveModifiers(context);
            return;
        }
        if (!this.isUnlocked()) {
            this.onRemoveModifiers(context);
            return;
        }
        if (this.canApply(context)) {
            this.onAddModifiers(context);
        } else {
            this.onRemoveModifiers(context);
        }
    }

    @Override
    public Stream<VaultGearAttributeInstance<?>> getGearAttributes(SkillContext context) {
        return this.canApply(context) ? Stream.of(VaultGearAttributeInstance.cast(this.getAttribute(), this.getValue())) : Stream.empty();
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.GEAR_ATTRIBUTE.writeBits(this.attribute, buffer);
        Adapters.DOUBLE.writeBits(this.value, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.attribute = Adapters.GEAR_ATTRIBUTE.readBits(buffer).orElseThrow();
        this.value = (Double)Adapters.DOUBLE.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.GEAR_ATTRIBUTE.writeNbt(this.attribute).ifPresent(tag -> nbt.m_128365_("attribute", tag));
            Adapters.DOUBLE.writeNbt(this.value).ifPresent(tag -> nbt.m_128365_("value", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.attribute = Adapters.GEAR_ATTRIBUTE.readNbt(nbt.m_128423_("attribute")).orElseThrow(() -> new IllegalStateException("Unknown attribute in " + String.valueOf(nbt)));
        this.value = (Double)Adapters.DOUBLE.readNbt(nbt.m_128423_("value")).orElseThrow();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.GEAR_ATTRIBUTE.writeJson(this.attribute).ifPresent(element -> json.add("attribute", element));
            Adapters.DOUBLE.writeJson(this.value).ifPresent(element -> json.add("value", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.attribute = Adapters.GEAR_ATTRIBUTE.readJson(json.get("attribute")).orElseThrow(() -> new IllegalStateException("Unknown attribute in " + String.valueOf(json)));
        this.value = (Double)Adapters.DOUBLE.readJson(json.get("value")).orElseThrow();
    }
}

