/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.prestige;

import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.MultiJumpMessage;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.TickingSkill;
import iskallia.vault.skill.prestige.core.ActivatePrestigePower;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MultiJumpPrestigePower
extends ActivatePrestigePower
implements TickingSkill {
    private static final int MAX_JUMPS = 3;
    private static int clientJumpCount = 0;
    private static boolean clientIsJumpHeld = false;

    @Override
    public void onTick(SkillContext context) {
    }

    @Override
    public void onClientTick(SkillContext context) {
        if (!this.isUnlocked()) {
            return;
        }
        if (!this.isActive()) {
            return;
        }
        context.getSource().as(LocalPlayer.class).ifPresent(this::onClientTick);
    }

    @Override
    public boolean onEnable(SkillContext context) {
        clientJumpCount = 0;
        clientIsJumpHeld = false;
        return true;
    }

    @Override
    public boolean onDisable(SkillContext context) {
        clientJumpCount = 0;
        clientIsJumpHeld = false;
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onClientTick(Player player) {
        if (!(player instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer clientPlayer = (LocalPlayer)player;
        if (clientPlayer != Minecraft.m_91087_().f_91074_) {
            return;
        }
        if (clientPlayer.m_150110_().f_35935_) {
            return;
        }
        if (clientPlayer.m_20096_()) {
            clientJumpCount = 0;
        } else if (clientPlayer.f_108618_.f_108572_) {
            if (!clientIsJumpHeld && clientJumpCount <= 3) {
                ++clientJumpCount;
                clientPlayer.m_6135_();
                Vec3 movement = clientPlayer.m_20184_();
                clientPlayer.m_20256_(new Vec3(movement.m_7096_(), movement.m_7098_() + 0.2, movement.m_7094_()));
                ModNetwork.CHANNEL.sendToServer((Object)MultiJumpMessage.getInstance());
            }
            clientIsJumpHeld = true;
        } else {
            clientIsJumpHeld = false;
        }
    }
}

