/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.prestige;

import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.TickingSkill;
import iskallia.vault.skill.prestige.core.PrestigePower;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;

public class OriginalWardPrestigePower
extends PrestigePower
implements TickingSkill {
    private int thresholdTicks;

    public OriginalWardPrestigePower() {
        this.thresholdTicks = 1200;
    }

    public OriginalWardPrestigePower(int thresholdTicks) {
        this.thresholdTicks = thresholdTicks;
    }

    public int getThresholdTicks() {
        return this.thresholdTicks;
    }

    @Override
    public void onTick(SkillContext context) {
        if (!this.isUnlocked()) {
            return;
        }
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            long ticksSinceDamage = player.f_19853_.m_46467_() - player.f_20930_;
            if (ticksSinceDamage >= (long)this.thresholdTicks) {
                float max = player.m_21233_();
                if (player.m_6103_() < max) {
                    player.m_7911_(max);
                }
            }
        });
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT.writeBits(this.thresholdTicks, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.thresholdTicks = Adapters.INT.readBits(buffer).orElse(1200);
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.thresholdTicks).ifPresent(tag -> nbt.m_128365_("thresholdTicks", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.thresholdTicks = Adapters.INT.readNbt(nbt.m_128423_("thresholdTicks")).orElse(1200);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.thresholdTicks).ifPresent(element -> json.add("thresholdTicks", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.thresholdTicks = Adapters.INT.readJson(json.get("thresholdTicks")).orElse(1200);
    }

    @Override
    public void writeBytes(ByteBuf buffer) {
        super.writeBytes(buffer);
        Adapters.INT.writeBytes(this.thresholdTicks, buffer);
    }

    @Override
    public void readBytes(ByteBuf buffer) {
        super.readBytes(buffer);
        this.thresholdTicks = Adapters.INT.readBytes(buffer).orElse(1200);
    }
}

