/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.prestige;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.prestige.core.PrestigePower;
import iskallia.vault.skill.prestige.helper.PrestigeHelper;
import iskallia.vault.skill.tree.PrestigeTree;
import iskallia.vault.util.calc.PlayerStat;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class PlayerStatPrestigePower
extends PrestigePower {
    private PlayerStat stat;
    private float value;
    private EntityPredicate enemy;
    public static final EnumAdapter<PlayerStat> STAT;

    public PlayerStat getStat() {
        return this.stat;
    }

    public float getValue() {
        return this.value;
    }

    public EntityPredicate getEnemy() {
        return this.enemy;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        STAT.writeBits(this.stat, buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.value), buffer);
        Adapters.ENTITY_PREDICATE.writeBits(this.enemy, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.stat = STAT.readBits(buffer).orElse(null);
        this.value = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.enemy = Adapters.ENTITY_PREDICATE.readBits(buffer).orElse(null);
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            STAT.writeNbt(this.stat).ifPresent(tag -> nbt.m_128365_("stat", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.value)).ifPresent(tag -> nbt.m_128365_("value", tag));
            Adapters.ENTITY_PREDICATE.writeNbt(this.enemy).ifPresent(tag -> nbt.m_128365_("enemy", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.stat = STAT.readNbt(nbt.m_128423_("stat")).orElse(null);
        this.value = Adapters.FLOAT.readNbt(nbt.m_128423_("value")).orElse(Float.valueOf(0.0f)).floatValue();
        this.enemy = Adapters.ENTITY_PREDICATE.readNbt(nbt.m_128423_("enemy")).orElse(null);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            STAT.writeJson(this.stat).ifPresent(tag -> json.add("stat", tag));
            Adapters.FLOAT.writeJson(Float.valueOf(this.value)).ifPresent(tag -> json.add("value", tag));
            Adapters.ENTITY_PREDICATE.writeJson(this.enemy).ifPresent(tag -> json.add("enemy", tag));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.stat = STAT.readJson(json.get("stat")).orElse(null);
        this.value = Adapters.FLOAT.readJson(json.get("value")).orElse(Float.valueOf(0.0f)).floatValue();
        this.enemy = Adapters.ENTITY_PREDICATE.readJson(json.get("enemy")).orElse(null);
    }

    static {
        CommonEvents.PLAYER_STAT.register(PlayerStatPrestigePower.class, data -> {
            LivingEntity patt1058$temp = data.getEntity();
            if (!(patt1058$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt1058$temp;
            if (PrestigeHelper.arePrestigePowersDisabled((Player)player)) {
                return;
            }
            PrestigeTree powers = PrestigeHelper.getPrestige((Player)player);
            for (PlayerStatPrestigePower power : powers.getAll(PlayerStatPrestigePower.class, Skill::isUnlocked)) {
                if (power.getStat() != data.getStat() || power.getEnemy() != null && (data.getEnemy().isEmpty() || !power.getEnemy().test((Entity)data.getEnemy().get()))) continue;
                data.setValue(data.getValue() + power.getValue());
            }
        });
        STAT = Adapters.ofEnum(PlayerStat.class, EnumAdapter.Mode.NAME);
    }
}

