/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.prestige;

import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.TickingSkill;
import iskallia.vault.skill.prestige.core.ActivatePrestigePower;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionEffectPrestigePower
extends ActivatePrestigePower
implements TickingSkill {
    private ResourceLocation effectId;
    private int amplifier;
    private boolean ambient;
    private boolean visible;

    public PotionEffectPrestigePower() {
        this.effectId = null;
        this.amplifier = 0;
        this.ambient = false;
        this.visible = true;
    }

    public PotionEffectPrestigePower(ResourceLocation effectId, int amplifier) {
        this.effectId = effectId;
        this.amplifier = amplifier;
        this.ambient = false;
        this.visible = true;
    }

    public PotionEffectPrestigePower(int unlockLevel, int learnPointCost, int regretCost, ResourceLocation effectId, int amplifier, boolean ambient, boolean visible) {
        super(unlockLevel, learnPointCost, regretCost);
        this.effectId = effectId;
        this.amplifier = amplifier;
        this.ambient = ambient;
        this.visible = visible;
    }

    public ResourceLocation getEffectId() {
        return this.effectId;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public boolean isAmbient() {
        return this.ambient;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public MobEffect getEffect() {
        return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(this.effectId);
    }

    @Override
    public void onTick(SkillContext context) {
        if (!this.isUnlocked()) {
            return;
        }
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            MobEffect effect = this.getEffect();
            if (effect != null) {
                if (!this.isActive()) {
                    player.m_21195_(effect);
                    return;
                }
                if (player.f_19797_ % 20 == 0) {
                    MobEffectInstance effectInstance = new MobEffectInstance(effect, 200, this.amplifier, this.ambient, this.visible);
                    player.m_7292_(effectInstance);
                }
            }
        });
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.IDENTIFIER.asNullable().writeBits(this.effectId, buffer);
        Adapters.INT.writeBits(this.amplifier, buffer);
        Adapters.BOOLEAN.writeBits(this.ambient, buffer);
        Adapters.BOOLEAN.writeBits(this.visible, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.effectId = Adapters.IDENTIFIER.asNullable().readBits(buffer).orElse(null);
        this.amplifier = Adapters.INT.readBits(buffer).orElse(0);
        this.ambient = Adapters.BOOLEAN.readBits(buffer).orElse(false);
        this.visible = Adapters.BOOLEAN.readBits(buffer).orElse(true);
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.IDENTIFIER.asNullable().writeNbt(this.effectId).ifPresent(tag -> nbt.m_128365_("effectId", tag));
            Adapters.INT.writeNbt(this.amplifier).ifPresent(tag -> nbt.m_128365_("amplifier", tag));
            Adapters.BOOLEAN.writeNbt(this.ambient).ifPresent(tag -> nbt.m_128365_("ambient", tag));
            Adapters.BOOLEAN.writeNbt(this.visible).ifPresent(tag -> nbt.m_128365_("visible", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.effectId = Adapters.IDENTIFIER.asNullable().readNbt(nbt.m_128423_("effectId")).orElse(null);
        this.amplifier = Adapters.INT.readNbt(nbt.m_128423_("amplifier")).orElse(0);
        this.ambient = Adapters.BOOLEAN.readNbt(nbt.m_128423_("ambient")).orElse(false);
        this.visible = Adapters.BOOLEAN.readNbt(nbt.m_128423_("visible")).orElse(true);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.IDENTIFIER.asNullable().writeJson(this.effectId).ifPresent(element -> json.add("effectId", element));
            Adapters.INT.writeJson(this.amplifier).ifPresent(element -> json.add("amplifier", element));
            Adapters.BOOLEAN.writeJson(this.ambient).ifPresent(element -> json.add("ambient", element));
            Adapters.BOOLEAN.writeJson(this.visible).ifPresent(element -> json.add("visible", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.effectId = Adapters.IDENTIFIER.asNullable().readJson(json.get("effectId")).orElse(null);
        this.amplifier = Adapters.INT.readJson(json.get("amplifier")).orElse(0);
        this.ambient = Adapters.BOOLEAN.readJson(json.get("ambient")).orElse(false);
        this.visible = Adapters.BOOLEAN.readJson(json.get("visible")).orElse(true);
    }

    @Override
    public void writeBytes(ByteBuf buffer) {
        super.writeBytes(buffer);
        Adapters.IDENTIFIER.asNullable().writeBytes(this.effectId, buffer);
        Adapters.INT.writeBytes(this.amplifier, buffer);
        Adapters.BOOLEAN.writeBytes(this.ambient, buffer);
        Adapters.BOOLEAN.writeBytes(this.visible, buffer);
    }

    @Override
    public void readBytes(ByteBuf buffer) {
        super.readBytes(buffer);
        this.effectId = Adapters.IDENTIFIER.asNullable().readBytes(buffer).orElse(null);
        this.amplifier = Adapters.INT.readBytes(buffer).orElse(0);
        this.ambient = Adapters.BOOLEAN.readBytes(buffer).orElse(false);
        this.visible = Adapters.BOOLEAN.readBytes(buffer).orElse(true);
    }
}

