/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.prestige;

import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.prestige.core.PrestigePower;
import iskallia.vault.skill.prestige.helper.PrestigeHelper;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;

public class ShieldedPrestigePower
extends PrestigePower {
    private float percentageOfHearts;

    public float getPercentageOfHearts() {
        return this.percentageOfHearts;
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(tag -> {
            Adapters.FLOAT.asNullable().writeNbt(Float.valueOf(this.percentageOfHearts)).ifPresent(t -> tag.m_128365_("percentageOfHearts", t));
            return tag;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.percentageOfHearts = Adapters.FLOAT.asNullable().readNbt(nbt.m_128423_("percentageOfHearts")).orElse(Float.valueOf(1.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.asNullable().writeJson(Float.valueOf(this.percentageOfHearts)).ifPresent(t -> json.add("percentageOfHearts", t));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.percentageOfHearts = Adapters.FLOAT.asNullable().readJson(json.get("percentageOfHearts")).orElse(Float.valueOf(1.0f)).floatValue();
    }

    @Override
    public void writeBytes(ByteBuf buffer) {
        super.writeBytes(buffer);
        Adapters.FLOAT.asNullable().writeBytes(Float.valueOf(this.percentageOfHearts), buffer);
    }

    @Override
    public void readBytes(ByteBuf buffer) {
        super.readBytes(buffer);
        this.percentageOfHearts = Adapters.FLOAT.asNullable().readBytes(buffer).orElse(Float.valueOf(1.0f)).floatValue();
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.asNullable().writeBits(Float.valueOf(this.percentageOfHearts), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.percentageOfHearts = Adapters.FLOAT.asNullable().readBits(buffer).orElse(Float.valueOf(1.0f)).floatValue();
    }

    static {
        CommonEvents.LISTENER_JOIN.register(ShieldedPrestigePower.class, data -> data.getListener().getPlayer().ifPresent(serverPlayer -> {
            if (PrestigeHelper.arePrestigePowersDisabled((Player)serverPlayer)) {
                return;
            }
            float percentage = 0.0f;
            for (ShieldedPrestigePower power : PrestigeHelper.getPrestige((Player)serverPlayer).getAll(ShieldedPrestigePower.class, Skill::isUnlocked)) {
                percentage += power.getPercentageOfHearts();
            }
            if (percentage <= 0.0f) {
                return;
            }
            percentage = Math.min(percentage, 1.0f);
            serverPlayer.m_7911_(serverPlayer.m_6103_() + serverPlayer.m_21233_() * percentage);
        }));
    }
}

