/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.prestige;

import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.prestige.core.PrestigePower;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;

public class SuperCrystalsPrestigePower
extends PrestigePower {
    private int extraCapacity;

    public SuperCrystalsPrestigePower() {
        this.extraCapacity = 50;
    }

    public SuperCrystalsPrestigePower(int extraCapacity) {
        this.extraCapacity = extraCapacity;
    }

    public SuperCrystalsPrestigePower(int unlockLevel, int learnPointCost, int regretCost, int extraCapacity) {
        super(unlockLevel, learnPointCost, regretCost);
        this.extraCapacity = extraCapacity;
    }

    public int getExtraCapacity() {
        return this.extraCapacity;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT.writeBits(this.extraCapacity, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.extraCapacity = Adapters.INT.readBits(buffer).orElse(50);
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.extraCapacity).ifPresent(tag -> nbt.m_128365_("extraCapacity", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.extraCapacity = Adapters.INT.readNbt(nbt.m_128423_("extraCapacity")).orElse(50);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.extraCapacity).ifPresent(element -> json.add("extraCapacity", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.extraCapacity = Adapters.INT.readJson(json.get("extraCapacity")).orElse(50);
    }

    @Override
    public void writeBytes(ByteBuf buffer) {
        super.writeBytes(buffer);
        Adapters.INT.writeBytes(this.extraCapacity, buffer);
    }

    @Override
    public void readBytes(ByteBuf buffer) {
        super.readBytes(buffer);
        this.extraCapacity = Adapters.INT.readBytes(buffer).orElse(50);
    }
}

