/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.prestige;

import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.prestige.core.PrestigePower;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;

public class TemporalShardChancePrestigePower
extends PrestigePower {
    private float chance;

    public TemporalShardChancePrestigePower() {
        this.chance = 0.0f;
    }

    public TemporalShardChancePrestigePower(float chance) {
        this.chance = chance;
    }

    public float getChance() {
        return this.chance;
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.asNullable().writeNbt(Float.valueOf(this.chance)).ifPresent(tag -> nbt.m_128365_("chance", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.chance = Adapters.FLOAT.asNullable().readNbt(nbt.m_128423_("chance")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.asNullable().writeJson(Float.valueOf(this.chance)).ifPresent(tag -> json.add("chance", tag));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.chance = Adapters.FLOAT.asNullable().readJson(json.get("chance")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.asNullable().writeBits(Float.valueOf(this.chance), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.chance = Adapters.FLOAT.asNullable().readBits(buffer).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public void writeBytes(ByteBuf buffer) {
        super.writeBytes(buffer);
        Adapters.FLOAT.asNullable().writeBytes(Float.valueOf(this.chance), buffer);
    }

    @Override
    public void readBytes(ByteBuf buffer) {
        super.readBytes(buffer);
        this.chance = Adapters.FLOAT.asNullable().readBytes(buffer).orElse(Float.valueOf(0.0f)).floatValue();
    }
}

