/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.prestige;

import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.prestige.core.PrestigePower;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;

public class ToolDurabilityPrestigePower
extends PrestigePower {
    private float damageReduction;

    public ToolDurabilityPrestigePower() {
        this.damageReduction = 1.0f;
    }

    public ToolDurabilityPrestigePower(float damageReduction) {
        this.damageReduction = Math.max(0.0f, Math.min(1.0f, damageReduction));
    }

    public ToolDurabilityPrestigePower(int unlockLevel, int learnPointCost, int regretCost, float damageReduction) {
        super(unlockLevel, learnPointCost, regretCost);
        this.damageReduction = Math.max(0.0f, Math.min(1.0f, damageReduction));
    }

    public float getDamageReduction() {
        return this.damageReduction;
    }

    public int getReducedDamage(int originalDamage) {
        return Math.round((float)originalDamage * (1.0f - this.damageReduction));
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.damageReduction), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.damageReduction = Adapters.FLOAT.readBits(buffer).orElse(Float.valueOf(1.0f)).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.damageReduction)).ifPresent(tag -> nbt.m_128365_("damageReduction", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.damageReduction = Adapters.FLOAT.readNbt(nbt.m_128423_("damageReduction")).orElse(Float.valueOf(1.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.damageReduction)).ifPresent(element -> json.add("damageReduction", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.damageReduction = Adapters.FLOAT.readJson(json.get("damageReduction")).orElse(Float.valueOf(1.0f)).floatValue();
    }

    @Override
    public void writeBytes(ByteBuf buffer) {
        super.writeBytes(buffer);
        Adapters.FLOAT.writeBytes(Float.valueOf(this.damageReduction), buffer);
    }

    @Override
    public void readBytes(ByteBuf buffer) {
        super.readBytes(buffer);
        this.damageReduction = Adapters.FLOAT.readBytes(buffer).orElse(Float.valueOf(1.0f)).floatValue();
    }
}

