/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.prestige;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.init.ModEffects;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.prestige.core.PrestigePower;
import iskallia.vault.skill.prestige.helper.PrestigeHelper;
import iskallia.vault.skill.tree.PrestigeTree;
import iskallia.vault.util.calc.PlayerStat;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class TreasureHunterPrestigePower
extends PrestigePower {
    private float bonusPerStack = 0.05f;
    private int maxStacks = 20;

    public TreasureHunterPrestigePower() {
    }

    public TreasureHunterPrestigePower(float bonusPerStack, int maxStacks) {
        this.bonusPerStack = bonusPerStack;
        this.maxStacks = maxStacks;
    }

    public float getBonusPerStack() {
        return this.bonusPerStack;
    }

    public int getMaxStacks() {
        return this.maxStacks;
    }

    private static float getBonus(ServerPlayer player) {
        if (player.m_20194_() == null) {
            return 0.0f;
        }
        if (PrestigeHelper.arePrestigePowersDisabled((Player)player)) {
            return 0.0f;
        }
        PrestigeTree tree = PrestigeHelper.getPrestige((Player)player);
        return (float)tree.getAll(TreasureHunterPrestigePower.class, Skill::isUnlocked).stream().mapToDouble(TreasureHunterPrestigePower::getBonusPerStack).sum();
    }

    private static void resetStacks(ServerPlayer player) {
        TreasureHunterStackStore.reset(player);
    }

    private static void updateIndicatorEffect(ServerPlayer player, int stacks) {
        if (player.m_20194_() == null) {
            return;
        }
        if (stacks <= 0 || PrestigeHelper.arePrestigePowersDisabled((Player)player)) {
            player.m_21195_(ModEffects.TREASURE);
            return;
        }
        int amplifier = Math.max(stacks - 1, 0);
        MobEffectInstance current = player.m_21124_(ModEffects.TREASURE);
        if (current != null && current.m_19564_() == amplifier && current.m_19557_() > 40) {
            return;
        }
        player.m_7292_(new MobEffectInstance(ModEffects.TREASURE, 200, amplifier, false, true, true));
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.bonusPerStack)).ifPresent(tag -> nbt.m_128365_("bonusPerStack", tag));
            Adapters.INT.writeNbt(this.maxStacks).ifPresent(tag -> nbt.m_128365_("maxStacks", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.bonusPerStack = Adapters.FLOAT.readNbt(nbt.m_128423_("bonusPerStack")).orElse(Float.valueOf(0.05f)).floatValue();
        this.maxStacks = Adapters.INT.readNbt(nbt.m_128423_("maxStacks")).orElse(20);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.bonusPerStack)).ifPresent(e -> json.add("bonusPerStack", e));
            Adapters.INT.writeJson(this.maxStacks).ifPresent(e -> json.add("maxStacks", e));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.bonusPerStack = Adapters.FLOAT.readJson(json.get("bonusPerStack")).orElse(Float.valueOf(0.05f)).floatValue();
        this.maxStacks = Adapters.INT.readJson(json.get("maxStacks")).orElse(20);
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.bonusPerStack), buffer);
        Adapters.INT.writeBits(this.maxStacks, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.bonusPerStack = Adapters.FLOAT.readBits(buffer).orElse(Float.valueOf(0.05f)).floatValue();
        this.maxStacks = Adapters.INT.readBits(buffer).orElse(20);
    }

    static {
        CommonEvents.PLAYER_STAT.of(PlayerStat.ITEM_QUANTITY).register(TreasureHunterPrestigePower.class, data -> {
            LivingEntity patt1073$temp = data.getEntity();
            if (!(patt1073$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt1073$temp;
            int stacks = TreasureHunterStackStore.getStacks(player.m_142081_());
            TreasureHunterPrestigePower.updateIndicatorEffect(player, stacks);
            float bonus = TreasureHunterPrestigePower.getBonus(player);
            if (bonus == 0.0f) {
                return;
            }
            data.setValue(data.getValue() + bonus * (float)stacks);
        });
        CommonEvents.PLAYER_STAT.of(PlayerStat.ITEM_RARITY).register(TreasureHunterPrestigePower.class, data -> {
            LivingEntity patt1622$temp = data.getEntity();
            if (!(patt1622$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt1622$temp;
            int stacks = TreasureHunterStackStore.getStacks(player.m_142081_());
            TreasureHunterPrestigePower.updateIndicatorEffect(player, stacks);
            float bonus = TreasureHunterPrestigePower.getBonus(player);
            if (bonus == 0.0f) {
                return;
            }
            data.setValue(data.getValue() + bonus * (float)stacks);
        });
        CommonEvents.CHEST_LOOT_GENERATION.post().register(TreasureHunterPrestigePower.class, event -> {
            ServerPlayer player = event.getPlayer();
            if (PrestigeHelper.arePrestigePowersDisabled((Player)player)) {
                return;
            }
            PrestigeTree powers = PrestigeHelper.getPrestige((Player)player);
            List<TreasureHunterPrestigePower> list = powers.getAll(TreasureHunterPrestigePower.class, Skill::isUnlocked);
            if (list.isEmpty()) {
                return;
            }
            int max = list.stream().mapToInt(TreasureHunterPrestigePower::getMaxStacks).max().orElse(0);
            TreasureHunterStackStore.increment(player, max);
        });
        CommonEvents.ENTITY_DAMAGE.register(TreasureHunterPrestigePower.class, event -> {
            Entity patt2901$temp;
            Entity patt2768$temp = event.getEntity();
            if (patt2768$temp instanceof ServerPlayer) {
                ServerPlayer damaged = (ServerPlayer)patt2768$temp;
                TreasureHunterPrestigePower.resetStacks(damaged);
            }
            if ((patt2901$temp = event.getSource().m_7639_()) instanceof ServerPlayer) {
                ServerPlayer attacker = (ServerPlayer)patt2901$temp;
                TreasureHunterPrestigePower.resetStacks(attacker);
            }
        });
    }

    public class TreasureHunterStackStore {
        private static final Map<UUID, Integer> STACKS = new WeakHashMap<UUID, Integer>();

        public static int getStacks(UUID playerId) {
            return STACKS.getOrDefault(playerId, 0);
        }

        public static void increment(ServerPlayer player, int max) {
            UUID playerId = player.m_142081_();
            int current = TreasureHunterStackStore.getStacks(playerId);
            if (current < max) {
                STACKS.put(playerId, current + 1);
                TreasureHunterPrestigePower.updateIndicatorEffect(player, current + 1);
            } else {
                TreasureHunterPrestigePower.updateIndicatorEffect(player, current);
            }
        }

        public static void reset(ServerPlayer player) {
            UUID playerId = player.m_142081_();
            STACKS.remove(playerId);
            TreasureHunterPrestigePower.updateIndicatorEffect(player, 0);
        }
    }
}

