/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.prestige;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.TickingSkill;
import iskallia.vault.skill.prestige.core.ActivatePrestigePower;
import iskallia.vault.skill.talent.GearAttributeSkill;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class VanillaAttributePrestigePower
extends ActivatePrestigePower
implements GearAttributeSkill,
TickingSkill {
    protected static final EnumAdapter<AttributeModifier.Operation> OPERATION_ORDINAL = Adapters.ofEnum(AttributeModifier.Operation.class, EnumAdapter.Mode.ORDINAL);
    protected static final EnumAdapter<AttributeModifier.Operation> OPERATION_NAME = Adapters.ofEnum(AttributeModifier.Operation.class, EnumAdapter.Mode.NAME);
    private Attribute attribute;
    private AttributeModifier.Operation operation;
    public double amount;

    public VanillaAttributePrestigePower(int unlockLevel, int learnPointCost, int regretCost, Attribute attribute, AttributeModifier.Operation operation, double amount) {
        super(unlockLevel, learnPointCost, regretCost);
        this.attribute = attribute;
        this.operation = operation;
        this.amount = amount;
    }

    public VanillaAttributePrestigePower() {
    }

    @Override
    public void onAdd(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(this::refreshSnapshot);
    }

    @Override
    public void onRemove(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(this::refreshSnapshot);
    }

    @Override
    public void onTick(SkillContext context) {
        if (!this.isUnlocked() || !this.isActive()) {
            this.onRemoveModifiers(context);
        } else {
            this.onAddModifiers(context);
        }
    }

    @Override
    public Stream<VaultGearAttributeInstance<?>> getGearAttributes(SkillContext context) {
        VaultGearAttribute<?> attribute = ModGearAttributes.getGearAttribute(this.attribute, this.operation);
        return attribute == null ? Stream.empty() : Stream.of(VaultGearAttributeInstance.cast(attribute, this.amount));
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.ATTRIBUTE.writeBits(this.attribute, buffer);
        OPERATION_ORDINAL.writeBits(this.operation, buffer);
        Adapters.DOUBLE.writeBits(this.amount, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.attribute = Adapters.ATTRIBUTE.readBits(buffer).orElseThrow();
        this.operation = OPERATION_ORDINAL.readBits(buffer).orElseThrow();
        this.amount = (Double)Adapters.DOUBLE.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.ATTRIBUTE.writeNbt(this.attribute).ifPresent(tag -> nbt.m_128365_("attribute", tag));
            OPERATION_NAME.writeNbt(this.operation).ifPresent(tag -> nbt.m_128365_("operation", tag));
            Adapters.DOUBLE.writeNbt(this.amount).ifPresent(tag -> nbt.m_128365_("amount", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.attribute = Adapters.ATTRIBUTE.readNbt(nbt.m_128423_("attribute")).orElseThrow(() -> new IllegalStateException("Unknown attribute in " + String.valueOf(nbt)));
        this.operation = OPERATION_NAME.readNbt(nbt.m_128423_("operation")).orElseThrow();
        this.amount = (Double)Adapters.DOUBLE.readNbt(nbt.m_128423_("amount")).orElseThrow();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.ATTRIBUTE.writeJson(this.attribute).ifPresent(element -> json.add("attribute", element));
            OPERATION_NAME.writeJson(this.operation).ifPresent(element -> json.add("operation", element));
            Adapters.DOUBLE.writeJson(this.amount).ifPresent(element -> json.add("amount", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.attribute = Adapters.ATTRIBUTE.readJson(json.get("attribute")).orElseThrow(() -> new IllegalStateException("Unknown attribute in " + String.valueOf(json)));
        this.operation = OPERATION_NAME.readJson(json.get("operation")).orElseThrow();
        this.amount = (Double)Adapters.DOUBLE.readJson(json.get("amount")).orElseThrow();
    }
}

