/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.prestige.core;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.prestige.core.PrestigePower;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;

public abstract class ActivatePrestigePower
extends PrestigePower {
    private boolean active = false;

    public ActivatePrestigePower() {
    }

    public ActivatePrestigePower(int unlockLevel, int learnCost, int regretCost) {
        super(unlockLevel, learnCost, regretCost);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean onEnable(SkillContext context) {
        return true;
    }

    public boolean onDisable(SkillContext context) {
        return true;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.BOOLEAN.writeBits(this.active, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.active = Adapters.BOOLEAN.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.BOOLEAN.writeNbt(this.active).ifPresent(tag -> nbt.m_128365_("active", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.active = Adapters.BOOLEAN.readNbt(nbt.m_128423_("active")).orElse(false);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.BOOLEAN.writeJson(this.active).ifPresent(value -> json.add("active", value));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.active = Adapters.BOOLEAN.readJson(json.get("active")).orElse(false);
    }
}

